/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.level;

import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.util.BlockPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChunkerPortal {
    private Dimension dimension;
    private int x;
    private int y;
    private int z;
    private byte width;
    private byte xa;
    private byte za;

    public ChunkerPortal(Dimension dimension, int x, int y, int z, byte width, byte xa, byte za) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.width = width;
        this.xa = xa;
        this.za = za;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public byte getWidth() {
        return this.width;
    }

    public void setWidth(byte width) {
        this.width = width;
    }

    public byte getXa() {
        return this.xa;
    }

    public void setXa(byte xa) {
        this.xa = xa;
    }

    public byte getZa() {
        return this.za;
    }

    public void setZa(byte za) {
        this.za = za;
    }

    public List<BlockPosition> getHorizontalBlocks(ChunkCoordPair chunkCoordPair) {
        int originChunkX = this.x >> 4;
        int originChunkZ = this.z >> 4;
        int offsetChunkX = this.x + (this.width - 1) * this.getXa() >> 4;
        int offsetChunkZ = this.z + (this.width - 1) * this.getZa() >> 4;
        int minChunkX = Math.min(originChunkX, offsetChunkX);
        int minChunkZ = Math.min(originChunkZ, offsetChunkZ);
        int maxChunkX = Math.max(originChunkX, offsetChunkX);
        int maxChunkZ = Math.max(originChunkZ, offsetChunkZ);
        if (chunkCoordPair.chunkX() < minChunkX || chunkCoordPair.chunkZ() < minChunkZ) {
            return Collections.emptyList();
        }
        if (chunkCoordPair.chunkX() > maxChunkX || chunkCoordPair.chunkZ() > maxChunkZ) {
            return Collections.emptyList();
        }
        ArrayList<BlockPosition> blockPositions = new ArrayList<BlockPosition>();
        int offsetX = this.x + (this.width - 1) * this.getXa();
        int offsetZ = this.z + (this.width - 1) * this.getZa();
        int minX = Math.min(this.x, offsetX);
        int minZ = Math.min(this.z, offsetZ);
        int maxX = Math.max(this.x, offsetX);
        int maxZ = Math.max(this.z, offsetZ);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                if (!chunkCoordPair.isInside(x, z)) continue;
                blockPositions.add(new BlockPosition(x, this.y, z));
            }
        }
        return blockPositions;
    }
}

