/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.level;

import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerPortal;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class ChunkerLevel {
    private ChunkerLevelSettings settings;
    @Nullable
    private ChunkerLevelPlayer player;
    private List<ChunkerMap> maps;
    @Nullable
    private CompoundTag originalLevelData;
    private List<ChunkerPortal> portals;

    public ChunkerLevel(ChunkerLevelSettings settings, @Nullable ChunkerLevelPlayer player, List<ChunkerMap> maps, @Nullable CompoundTag originalLevelData, List<ChunkerPortal> portals) {
        this.settings = settings;
        this.player = player;
        this.maps = maps;
        this.originalLevelData = originalLevelData;
        this.portals = portals;
    }

    public ChunkerLevel() {
    }

    public ChunkerLevelSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ChunkerLevelSettings settings) {
        this.settings = settings;
    }

    @Nullable
    public ChunkerLevelPlayer getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable ChunkerLevelPlayer player) {
        this.player = player;
    }

    public List<ChunkerMap> getMaps() {
        return this.maps;
    }

    public void setMaps(List<ChunkerMap> maps) {
        this.maps = maps;
    }

    @Nullable
    public CompoundTag getOriginalLevelData() {
        return this.originalLevelData;
    }

    public void setOriginalLevelData(@Nullable CompoundTag originalLevelData) {
        this.originalLevelData = originalLevelData;
    }

    public List<ChunkerPortal> getPortals() {
        return this.portals;
    }

    public void setPortals(List<ChunkerPortal> portals) {
        this.portals = portals;
    }

    public Optional<Integer> findMapIndexByOriginalID(long originalMapId) {
        for (int i = 0; i < this.maps.size(); ++i) {
            ChunkerMap map = this.maps.get(i);
            if (map.getOriginalId() == null || originalMapId != map.getOriginalId()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<ChunkerMap> getMapByIndex(int index) {
        if (index < 0 || index >= this.maps.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.maps.get(index));
    }

    public String toString() {
        return "ChunkerLevel{settings=" + String.valueOf(this.getSettings()) + ", player=" + String.valueOf(this.getPlayer()) + ", maps=" + String.valueOf(this.getMaps()) + ", originalLevelData=" + String.valueOf(this.getOriginalLevelData()) + ", portals=" + String.valueOf(this.getPortals()) + "}";
    }
}

