/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.palette;

import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.WriteablePalette;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;

public class SingleValuePalette<T>
implements Palette<T> {
    private final int dimensionSize;
    private final T value;

    public SingleValuePalette(int dimensionSize, T value) {
        this.dimensionSize = dimensionSize;
        this.value = value;
    }

    public static <T> SingleValuePalette<T> chunk(T identifier) {
        return new SingleValuePalette<T>(16, identifier);
    }

    @Override
    public int getKeyCount() {
        return 1;
    }

    @Override
    public T getKey(int keyIndex, T defaultValue) {
        return this.value;
    }

    @Override
    public T get(int x, int y, int z, T defaultValue) {
        return this.value;
    }

    @Override
    public <U> Palette<U> map(Function<T, U> mappingFunction) {
        return new SingleValuePalette<U>(this.dimensionSize, mappingFunction.apply(this.value));
    }

    @Override
    public boolean containsValue(Predicate<T> predicate) {
        return predicate.test(this.value);
    }

    @Override
    public boolean containsKey(Predicate<T> predicate) {
        return predicate.test(this.value);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public WriteablePalette<T> asWriteable() {
        ArrayList<T> keys = new ArrayList<T>(1);
        keys.add(this.value);
        return new ShortBasedPalette(keys, new short[this.dimensionSize][this.dimensionSize][this.dimensionSize]);
    }

    @Override
    public SingleValuePalette<T> compact(T defaultValue) {
        return this;
    }

    @Override
    public Palette<T> copy() {
        return new SingleValuePalette<T>(this.dimensionSize, this.value);
    }
}

