/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.palette;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.WriteablePalette;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class ShortBasedPalette<T>
implements WriteablePalette<T> {
    private final List<T> keys;
    private final short[][][] values;

    public ShortBasedPalette(List<T> keys, short[][][] values) {
        this.keys = keys;
        this.values = values;
    }

    public ShortBasedPalette(int keySizeHint, int dimensionSize) {
        this(new ArrayList(keySizeHint), new short[dimensionSize][dimensionSize][dimensionSize]);
    }

    public short[][][] getValues() {
        return this.values;
    }

    @Override
    public int getKeyCount() {
        return this.keys.size();
    }

    @Override
    public T getKey(int keyIndex, T defaultValue) {
        if (keyIndex < 0 || keyIndex >= this.keys.size()) {
            return defaultValue;
        }
        return this.keys.get(keyIndex);
    }

    @Override
    public T get(int x, int y, int z, T defaultValue) {
        return this.getKey(this.values[x][y][z], defaultValue);
    }

    @Override
    public short getOrCreateKey(T entry) {
        Preconditions.checkNotNull(entry);
        short index = (short)this.keys.indexOf(entry);
        if (index == -1) {
            index = (short)this.keys.size();
            this.keys.add(entry);
        }
        return index;
    }

    @Override
    public void set(int x, int y, int z, T key) {
        this.values[x][y][z] = this.getOrCreateKey(key);
    }

    @Override
    public void setPaletteIndex(int x, int y, int z, short paletteIndex) {
        this.values[x][y][z] = paletteIndex;
    }

    @Override
    public <U> Palette<U> map(Function<T, U> mappingFunction) {
        ArrayList<U> newKeys = new ArrayList<U>(this.keys.size());
        for (T key : this.keys) {
            newKeys.add(mappingFunction.apply(key));
        }
        return new ShortBasedPalette(newKeys, this.values);
    }

    @Override
    public boolean containsValue(Predicate<T> predicate) {
        int size = this.keys.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return predicate.test(this.keys.get(0));
        }
        ShortCollection matchedIndexes = null;
        for (int i = 0; i < size; i = (short)(i + 1)) {
            T identifier = this.keys.get(i);
            if (!predicate.test(identifier)) continue;
            if (matchedIndexes == null) {
                matchedIndexes = new ShortOpenHashSet(1);
            }
            matchedIndexes.add((short)i);
        }
        if (matchedIndexes == null) {
            return false;
        }
        short[][][] sArray = this.values;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short[][] yz;
            short[][] sArray2 = yz = sArray[i];
            int n2 = sArray2.length;
            for (int j = 0; j < n2; ++j) {
                short[] z;
                for (short entry : z = sArray2[j]) {
                    if (entry < 0 || entry >= size || !matchedIndexes.contains(entry)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Predicate<T> predicate) {
        for (T key : this.keys) {
            if (!predicate.test(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public WriteablePalette<T> asWriteable() {
        return this;
    }

    @Override
    public Palette<T> compact(T defaultValue) {
        if (this.keys.isEmpty()) {
            return EmptyPalette.instance(this.values.length);
        }
        short[] paletteRemapping = new short[this.keys.size()];
        Arrays.fill(paletteRemapping, (short)-1);
        ArrayList<T> oldKeys = new ArrayList<T>(this.keys);
        this.keys.clear();
        short[][][] sArray = this.values;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short[][] yz;
            for (short[] z : yz = sArray[i]) {
                for (int i2 = 0; i2 < z.length; ++i2) {
                    int newKeyIndex;
                    short oldKeyIndex = z[i2];
                    boolean validKeyIndex = oldKeyIndex >= 0 && oldKeyIndex < oldKeys.size();
                    int n2 = newKeyIndex = validKeyIndex ? paletteRemapping[oldKeyIndex] : -1;
                    if (newKeyIndex == -1) {
                        Object oldValue = validKeyIndex ? oldKeys.get(oldKeyIndex) : defaultValue;
                        newKeyIndex = (short)this.keys.indexOf(oldValue);
                        if (newKeyIndex == -1) {
                            newKeyIndex = (short)this.keys.size();
                            this.keys.add(oldValue);
                        }
                        if (validKeyIndex) {
                            paletteRemapping[oldKeyIndex] = newKeyIndex;
                        }
                    }
                    z[i2] = newKeyIndex;
                }
            }
        }
        if (this.keys.size() == 1) {
            return new SingleValuePalette<T>(this.values.length, this.keys.get(0));
        }
        return this;
    }

    @Override
    public ShortBasedPalette<T> copy() {
        short[][][] copiedValues = new short[this.values.length][][];
        for (int x = 0; x < this.values.length; ++x) {
            copiedValues[x] = new short[this.values[x].length][];
            for (int y = 0; y < this.values[x].length; ++y) {
                copiedValues[x][y] = (short[])this.values[x][y].clone();
            }
        }
        return new ShortBasedPalette<T>(new ArrayList<T>(this.keys), copiedValues);
    }
}

