/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;

public enum ChunkerFireworkShape {
    SMALL_BALL("small_ball"),
    LARGE_BALL("large_ball"),
    STAR("star"),
    CREEPER("creeper"),
    BURST("burst");

    private static final ChunkerFireworkShape[] VALUES;
    private static final Map<String, ChunkerFireworkShape> BY_NAME;
    private final String name;

    private ChunkerFireworkShape(String name) {
        this.name = name;
    }

    public static Optional<ChunkerFireworkShape> getByName(String name) {
        return Optional.ofNullable(BY_NAME.get(name));
    }

    public static Optional<ChunkerFireworkShape> getByID(int id) {
        if (id < 0 || id >= VALUES.length) {
            return Optional.empty();
        }
        return Optional.of(VALUES[id]);
    }

    public int getID() {
        return this.ordinal();
    }

    public String getName() {
        return this.name;
    }

    static {
        VALUES = ChunkerFireworkShape.values();
        BY_NAME = new Object2ObjectOpenHashMap<String, ChunkerFireworkShape>();
        for (ChunkerFireworkShape value : VALUES) {
            BY_NAME.put(value.getName(), value);
        }
    }
}

