/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;

public enum ChunkerDyeColor {
    WHITE("white"),
    ORANGE("orange"),
    MAGENTA("magenta"),
    LIGHT_BLUE("light_blue"),
    YELLOW("yellow"),
    LIME("lime"),
    PINK("pink"),
    GRAY("gray"),
    LIGHT_GRAY("light_gray"),
    CYAN("cyan"),
    PURPLE("purple"),
    BLUE("blue"),
    BROWN("brown"),
    GREEN("green"),
    RED("red"),
    BLACK("black");

    private static final ChunkerDyeColor[] VALUES;
    private static final Map<String, ChunkerDyeColor> BY_NAME;
    private final String name;

    private ChunkerDyeColor(String name) {
        this.name = name;
    }

    public static Optional<ChunkerDyeColor> getColorByReversedID(int id) {
        return ChunkerDyeColor.getColorByID(15 - id);
    }

    public static Optional<ChunkerDyeColor> getColorByID(int id) {
        if (id < 0 || id >= VALUES.length) {
            return Optional.empty();
        }
        return Optional.of(VALUES[id]);
    }

    public static Optional<ChunkerDyeColor> getColorByName(String name) {
        return Optional.ofNullable(BY_NAME.get(name));
    }

    public int getID() {
        return this.ordinal();
    }

    public int getReversedID() {
        return 15 - this.ordinal();
    }

    public String getName() {
        return this.name;
    }

    static {
        VALUES = ChunkerDyeColor.values();
        BY_NAME = new Object2ObjectOpenHashMap<String, ChunkerDyeColor>();
        for (ChunkerDyeColor value : VALUES) {
            BY_NAME.put(value.getName(), value);
        }
    }
}

