/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types;

import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;

public enum FacingDirectionHorizontal implements BlockStateValue
{
    NORTH(0, -1),
    EAST(1, 0),
    SOUTH(0, 1),
    WEST(-1, 0);

    private final int x;
    private final int z;

    private FacingDirectionHorizontal(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public static FacingDirectionHorizontal from2DByte(byte direction) {
        return switch (direction % 4) {
            case 0 -> SOUTH;
            case 1 -> WEST;
            case 2 -> NORTH;
            case 3 -> EAST;
            default -> NORTH;
        };
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public FacingDirectionHorizontal rotateClockwise() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORTH -> EAST;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            case EAST -> SOUTH;
        };
    }

    public FacingDirectionHorizontal rotateAntiClockwise() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORTH -> WEST;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            case EAST -> NORTH;
        };
    }

    public boolean isAdjacent(FacingDirectionHorizontal input) {
        int ordinalDiff = Math.abs(this.ordinal() - input.ordinal());
        return ordinalDiff == 1 || ordinalDiff == 3;
    }

    public BlockPreTransformHandler.Direction asDirection() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NORTH -> BlockPreTransformHandler.Direction.NORTH;
            case EAST -> BlockPreTransformHandler.Direction.EAST;
            case SOUTH -> BlockPreTransformHandler.Direction.SOUTH;
            case WEST -> BlockPreTransformHandler.Direction.WEST;
        };
    }

    public byte to2DByte() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SOUTH -> 0;
            case WEST -> 1;
            case NORTH -> 2;
            case EAST -> 3;
        };
    }
}

