/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states;

import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ComparableItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class BlockState<T extends BlockStateValue>
implements ComparableItemProperty<T> {
    private final String name;
    private final T defaultValue;
    private final T[] values;

    public BlockState(String name, T defaultValue, T[] values) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.values = values;
    }

    public BlockState(String name, T defaultValue, Supplier<T[]> values) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.values = (BlockStateValue[])values.get();
    }

    public String getName() {
        return this.name;
    }

    public T[] getValues() {
        return this.values;
    }

    @Override
    public int compareTo(@NotNull ComparableItemProperty<?> other) {
        if (other instanceof BlockState) {
            BlockState o = (BlockState)other;
            int value = this.getName().compareTo(o.getName());
            if (value != 0) {
                return value;
            }
        }
        return this.getClass().getName().compareTo(other.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockState)) {
            return false;
        }
        BlockState that = (BlockState)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.deepEquals(this.getValues(), that.getValues());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "BlockState{name='" + this.name + "', default='" + String.valueOf(this.defaultValue) + "', values=" + Arrays.toString(this.values) + "}";
    }

    public T getDefault() {
        return this.defaultValue;
    }
}

