/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block;

import com.google.common.collect.Sets;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ChunkerCustomBlockType
implements ChunkerBlockType {
    private final String identifier;
    private final Set<BlockState<?>> blockStates;

    public ChunkerCustomBlockType(String identifier, Set<BlockState<?>> blockStates) {
        this.identifier = identifier;
        this.blockStates = Sets.union(VanillaBlockStates.DEFAULT_BLOCK_STATES, blockStates);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int getRGBColor() {
        return 0;
    }

    @Override
    public boolean isAllFacesSolid() {
        return false;
    }

    @Override
    public Optional<Class<? extends BlockEntity>> getBlockEntityClass() {
        return Optional.empty();
    }

    @Override
    public Set<BlockState<?>> getStates() {
        return this.blockStates;
    }

    public String toString() {
        return "ChunkerCustomBlockType{identifier='" + this.getIdentifier() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChunkerCustomBlockType)) {
            return false;
        }
        ChunkerCustomBlockType that = (ChunkerCustomBlockType)o;
        return Objects.equals(this.getIdentifier(), that.getIdentifier());
    }

    public int hashCode() {
        return Objects.hashCode(this.getIdentifier());
    }

    public static class CustomBlockStateValue<T>
    implements BlockStateValue {
        private final T stateValue;

        public CustomBlockStateValue(T stateValue) {
            this.stateValue = stateValue;
        }

        public T getStateValue() {
            return this.stateValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CustomBlockStateValue)) {
                return false;
            }
            CustomBlockStateValue that = (CustomBlockStateValue)o;
            return Objects.equals(this.getStateValue(), that.getStateValue());
        }

        public int hashCode() {
            return Objects.hashCode(this.getStateValue());
        }

        public String toString() {
            return "CustomBlockStateValue{stateValue=" + String.valueOf(this.getStateValue()) + "}";
        }
    }
}

