/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.biome.layout;

import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerBiomes;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ChunkerPaletteBasedBiomes
implements ChunkerBiomes {
    private final List<Palette<ChunkerBiome>> chunks;

    public ChunkerPaletteBasedBiomes(List<Palette<ChunkerBiome>> chunks) {
        this.chunks = chunks;
    }

    @Override
    public ChunkerBiome[] asColumn(ChunkerBiome fallbackBiome) {
        Object[] output = new ChunkerBiome[256];
        if (!this.chunks.isEmpty()) {
            Palette<ChunkerBiome> palette = this.chunks.get(0);
            for (int i = 0; i < output.length; ++i) {
                int x = i & 0xF;
                int z = i >> 4 & 0xF;
                output[i] = palette.get(x, 0, z, fallbackBiome);
            }
        } else {
            Arrays.fill(output, fallbackBiome);
        }
        return output;
    }

    @Override
    public ChunkerBiome[] as4X4(ChunkerBiome fallbackBiome) {
        Object[] output = new ChunkerBiome[1024];
        if (!this.chunks.isEmpty()) {
            for (int chunkY = 0; chunkY < 16; ++chunkY) {
                Palette<ChunkerBiome> palette = this.chunks.size() <= chunkY ? this.chunks.get(this.chunks.size() - 1) : this.chunks.get(chunkY);
                for (int localX = 0; localX < 4; ++localX) {
                    for (int localY = 0; localY < 4; ++localY) {
                        for (int localZ = 0; localZ < 4; ++localZ) {
                            int x = (localX << 2) + 2;
                            int y = (localY << 2) + 2;
                            int z = (localZ << 2) + 2;
                            ChunkerBiome value = palette.get(x, y, z, fallbackBiome);
                            output[chunkY << 6 | localY << 4 | localZ << 2 | localX] = value;
                        }
                    }
                }
            }
        } else {
            Arrays.fill(output, fallbackBiome);
        }
        return output;
    }

    @Override
    public List<Palette<ChunkerBiome>> asPalette() {
        return this.chunks;
    }

    @Override
    public Palette<ChunkerBiome> as4X4Palette(int chunkY) {
        Palette<ChunkerBiome> oldPalette;
        if (this.chunks.isEmpty()) {
            return EmptyPalette.instance(4);
        }
        Palette<ChunkerBiome> palette = oldPalette = chunkY < 0 || chunkY >= this.chunks.size() ? this.chunks.get(this.chunks.size() - 1) : this.chunks.get(chunkY);
        if (oldPalette.isEmpty()) {
            return EmptyPalette.instance(4);
        }
        if (oldPalette.getKeyCount() == 1) {
            return new SingleValuePalette<ChunkerBiome>(4, oldPalette.getKey(0));
        }
        ShortBasedPalette<ChunkerBiome> palette2 = new ShortBasedPalette<ChunkerBiome>(oldPalette.getKeyCount(), 4);
        for (int clusterX = 0; clusterX < 4; ++clusterX) {
            for (int clusterY = 0; clusterY < 4; ++clusterY) {
                for (int clusterZ = 0; clusterZ < 4; ++clusterZ) {
                    ChunkerBiome biome = oldPalette.get((clusterX << 2) + 2, (clusterY << 2) + 2, (clusterZ << 2) + 2);
                    palette2.set(clusterX, clusterY, clusterZ, biome);
                }
            }
        }
        return palette2;
    }

    @Override
    public void remap(Function<ChunkerBiome, ChunkerBiome> mapping) {
        this.chunks.replaceAll(chunk -> chunk.map(mapping));
    }
}

