/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column.biome.layout;

import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerBiomes;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class ChunkerClusterBasedBiomes
implements ChunkerBiomes {
    private final ChunkerBiome[] clusters;

    public ChunkerClusterBasedBiomes(ChunkerBiome[] clusters) {
        this.clusters = clusters;
    }

    @Override
    public ChunkerBiome[] asColumn(ChunkerBiome fallbackBiome) {
        Object[] output = new ChunkerBiome[256];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int x = j << 2;
                int z = i << 2;
                int newIndex = z << 4 | x;
                int oldIndex = i << 2 | j;
                ChunkerBiome biome = this.clusters[oldIndex];
                for (int k = 0; k < 4; ++k) {
                    int offX = newIndex + (k << 4);
                    Arrays.fill(output, offX, offX + 4, biome);
                }
            }
        }
        return output;
    }

    @Override
    public ChunkerBiome[] as4X4(ChunkerBiome fallbackBiome) {
        return this.clusters;
    }

    @Override
    public List<Palette<ChunkerBiome>> asPalette() {
        ArrayList<Palette<ChunkerBiome>> chunkPalettes = new ArrayList<Palette<ChunkerBiome>>(16);
        for (int chunkY = 0; chunkY < 16; ++chunkY) {
            ShortBasedPalette<ChunkerBiome> palette = new ShortBasedPalette<ChunkerBiome>(4, 16);
            for (int clusterX = 0; clusterX < 4; ++clusterX) {
                for (int clusterY = 0; clusterY < 4; ++clusterY) {
                    for (int clusterZ = 0; clusterZ < 4; ++clusterZ) {
                        ChunkerBiome biome;
                        int x = clusterX << 2;
                        int y = clusterY << 2;
                        int z = clusterZ << 2;
                        int oldIndex = chunkY << 6 | clusterY << 4 | clusterZ << 2 | clusterX;
                        ChunkerBiome chunkerBiome = biome = oldIndex < this.clusters.length ? this.clusters[oldIndex] : null;
                        if (biome == null) continue;
                        short paletteIndex = palette.getOrCreateKey(biome);
                        for (int localX = 0; localX < 4; ++localX) {
                            for (int localY = 0; localY < 4; ++localY) {
                                for (int localZ = 0; localZ < 4; ++localZ) {
                                    palette.setPaletteIndex(x + localX, y + localY, z + localZ, paletteIndex);
                                }
                            }
                        }
                    }
                }
            }
            chunkPalettes.add(palette);
        }
        return chunkPalettes;
    }

    @Override
    public Palette<ChunkerBiome> as4X4Palette(int chunkY) {
        ShortBasedPalette<ChunkerBiome> palette = new ShortBasedPalette<ChunkerBiome>(4, 4);
        if (chunkY < 0) {
            chunkY = 0;
        }
        if (chunkY > 15) {
            chunkY = 15;
        }
        for (int clusterX = 0; clusterX < 4; ++clusterX) {
            for (int clusterY = 0; clusterY < 4; ++clusterY) {
                for (int clusterZ = 0; clusterZ < 4; ++clusterZ) {
                    int oldIndex = chunkY << 6 | clusterY << 4 | clusterZ << 2 | clusterX;
                    ChunkerBiome biome = this.clusters[oldIndex];
                    palette.set(clusterX, clusterY, clusterZ, biome);
                }
            }
        }
        return palette;
    }

    @Override
    public void remap(Function<ChunkerBiome, ChunkerBiome> mapping) {
        for (int i = 0; i < this.clusters.length; ++i) {
            this.clusters[i] = mapping.apply(this.clusters[i]);
        }
    }
}

