/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.intermediate.column;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerBiomes;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.WriteablePalette;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.HeightMap;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkerColumn {
    private final ChunkCoordPair position;
    private final List<Entity> entities = new ArrayList<Entity>(0);
    private final List<BlockEntity> blockEntities = new ArrayList<BlockEntity>(0);
    private final Byte2ObjectSortedMap<ChunkerChunk> chunks = new Byte2ObjectAVLTreeMap<ChunkerChunk>();
    private final Set<Edge> requiredPreTransformEdges = EnumSet.noneOf(Edge.class);
    @Nullable
    private ChunkerBiomes biomes;
    @Nullable
    private HeightMap heightMap;
    private boolean lightPopulated;
    private Consumer<Map<Edge, ChunkerColumn>> preTransformHandler;

    public ChunkerColumn(ChunkCoordPair position) {
        this.position = position;
    }

    public ChunkCoordPair getPosition() {
        return this.position;
    }

    @Nullable
    public ChunkerBiomes getBiomes() {
        return this.biomes;
    }

    public void setBiomes(@Nullable ChunkerBiomes biomes) {
        this.biomes = biomes;
    }

    @Nullable
    public HeightMap getHeightMap() {
        return this.heightMap;
    }

    public void setHeightMap(@Nullable HeightMap heightMap) {
        this.heightMap = heightMap;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public List<BlockEntity> getBlockEntities() {
        return this.blockEntities;
    }

    @NotNull
    public Byte2ObjectSortedMap<ChunkerChunk> getChunks() {
        return this.chunks;
    }

    public boolean isLightPopulated() {
        return this.lightPopulated;
    }

    public void setLightPopulated(boolean lightPopulated) {
        this.lightPopulated = lightPopulated;
    }

    public Set<Edge> getRequiredPreTransformEdges() {
        return this.requiredPreTransformEdges;
    }

    public void addPreTransformHandler(Set<Edge> edges, Consumer<Map<Edge, ChunkerColumn>> preTransformHandler) {
        this.preTransformHandler = this.preTransformHandler != null ? this.preTransformHandler.andThen(preTransformHandler) : preTransformHandler;
        this.requiredPreTransformEdges.addAll(edges);
    }

    public void preTransform(Map<Edge, ChunkerColumn> resolvedColumns) {
        if (this.preTransformHandler == null) {
            return;
        }
        this.preTransformHandler.accept(resolvedColumns);
        this.preTransformHandler = null;
    }

    @Nullable
    public Pair<Integer, ChunkerBlockIdentifier> getHighestBlock(int x, int z, Predicate<ChunkerBlockIdentifier> predicate) {
        if (this.chunks.isEmpty()) {
            return null;
        }
        x &= 0xF;
        z &= 0xF;
        ObjectSet chunkSet = this.chunks.byte2ObjectEntrySet();
        ObjectBidirectionalIterator<Byte2ObjectMap.Entry> iterator = chunkSet.iterator((Byte2ObjectMap.Entry)chunkSet.last());
        while (iterator.hasPrevious()) {
            ChunkerChunk chunk = (ChunkerChunk)((Byte2ObjectMap.Entry)iterator.previous()).getValue();
            Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
            if (palette == null || !palette.containsKey(predicate)) continue;
            for (int y = 15; y >= 0; --y) {
                ChunkerBlockIdentifier identifier = palette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                if (!predicate.test(identifier)) continue;
                return Pair.of(chunk.getY() << 4 | y, identifier);
            }
        }
        return null;
    }

    public ChunkerBlockIdentifier getBlock(int x, int y, int z) {
        if (this.chunks.isEmpty()) {
            return ChunkerBlockIdentifier.AIR;
        }
        byte chunkY = (byte)(y >> 4);
        ChunkerChunk chunk = (ChunkerChunk)this.chunks.get(chunkY);
        if (chunk == null) {
            return ChunkerBlockIdentifier.AIR;
        }
        return chunk.getPalette().get(x & 0xF, y & 0xF, z & 0xF, ChunkerBlockIdentifier.AIR);
    }

    public void setBlock(int x, int y, int z, ChunkerBlockIdentifier identifier) {
        byte chunkY = (byte)(y >> 4);
        ChunkerChunk chunk = (ChunkerChunk)this.chunks.get(chunkY);
        if (chunk == null) {
            chunk = new ChunkerChunk(chunkY);
            chunk.setPalette(ChunkerBlockIdentifier.AIR.asFilledChunkPalette());
            this.chunks.put(chunkY, chunk);
        }
        WriteablePalette<ChunkerBlockIdentifier> newPalette = chunk.getPalette().asWriteable();
        newPalette.set(x & 0xF, y & 0xF, z & 0xF, identifier);
        chunk.setPalette(newPalette);
    }

    @Nullable
    public BlockEntity getBlockEntity(int x, int y, int z) {
        x &= 0xF;
        z &= 0xF;
        for (BlockEntity blockEntity : this.blockEntities) {
            if ((blockEntity.getX() & 0xF) != x || blockEntity.getY() != y || (blockEntity.getZ() & 0xF) != z) continue;
            return blockEntity;
        }
        return null;
    }
}

