/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.writer;

import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;

public class ColumnWriterConversionHandler
implements ColumnConversionHandler {
    protected final ColumnWriter writer;

    public ColumnWriterConversionHandler(ColumnWriter writer) {
        this.writer = writer;
    }

    @Override
    public void convertColumn(ChunkerColumn column) {
        Task.asyncConsume("Writing Column", TaskWeight.NORMAL, this.writer::writeColumn, column);
    }

    @Override
    public void flushRegion(RegionCoordPair regionCoordPair) {
        Task.asyncConsume("Flushing Region", TaskWeight.NORMAL, this.writer::flushRegion, regionCoordPair);
    }

    @Override
    public void flushColumns() {
        Task.async("Flushing Writer Regions", TaskWeight.NORMAL, this.writer::flushColumns);
    }
}

