/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import java.util.Map;
import java.util.Set;

public interface HorizontalConnectableBlockPreTransformHandler
extends BlockPreTransformHandler {
    public static final Map<BlockPreTransformHandler.Direction, BlockState<Bool>> DIRECTION_TO_STATE = Map.of(BlockPreTransformHandler.Direction.NORTH, VanillaBlockStates.NORTH, BlockPreTransformHandler.Direction.EAST, VanillaBlockStates.EAST, BlockPreTransformHandler.Direction.SOUTH, VanillaBlockStates.SOUTH, BlockPreTransformHandler.Direction.WEST, VanillaBlockStates.WEST);

    @Override
    default public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        return this.calculateEdges(x, y, z, BlockPreTransformHandler.Direction.ALL_HORIZONTAL);
    }

    @Override
    default public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        for (BlockPreTransformHandler.Direction direction : BlockPreTransformHandler.Direction.ALL_HORIZONTAL) {
            ChunkerBlockIdentifier relative = this.getRelative(column, neighbours, x, y, z, direction);
            boolean connection = this.canConnect(blockIdentifier, direction, relative);
            BlockState<Bool> state = DIRECTION_TO_STATE.get((Object)direction);
            blockIdentifier = blockIdentifier.copyWith(state, connection ? Bool.TRUE : Bool.FALSE);
        }
        return blockIdentifier;
    }

    public boolean canConnect(ChunkerBlockIdentifier var1, BlockPreTransformHandler.Direction var2, ChunkerBlockIdentifier var3);
}

