/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform;

import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import java.util.function.Supplier;

public class ColumnPreTransformWriterConversionHandler
implements ColumnConversionHandler {
    private final Supplier<PreTransformManager> preTransformManagerGetter;
    private final ColumnConversionHandler delegate;
    private final boolean preTransformAllowed;

    public ColumnPreTransformWriterConversionHandler(Supplier<PreTransformManager> preTransformManagerGetter, ColumnConversionHandler delegate, boolean preTransformAllowed) {
        this.preTransformManagerGetter = preTransformManagerGetter;
        this.delegate = delegate;
        this.preTransformAllowed = preTransformAllowed;
    }

    @Override
    public void convertColumn(ChunkerColumn column) {
        PreTransformManager preTransformManager = this.preTransformManagerGetter.get();
        if (preTransformManager != null) {
            preTransformManager.solve(column, this.preTransformAllowed);
        }
        this.delegate.convertColumn(column);
    }

    @Override
    public void flushRegion(RegionCoordPair regionCoordPair) {
        this.delegate.flushRegion(regionCoordPair);
    }

    @Override
    public void flushColumns() {
        this.delegate.flushColumns();
    }
}

