/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pretransform;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public class ColumnPreTransformConversionHandler
implements ColumnConversionHandler {
    private final ColumnConversionHandler delegate;
    private final Map<RegionCoordPair, Map<ChunkCoordPair, ColumnData>> pending = new Object2ReferenceOpenHashMap<RegionCoordPair, Map<ChunkCoordPair, ColumnData>>();
    private final Set<RegionCoordPair> incompleteRegions = new ObjectOpenHashSet<RegionCoordPair>();
    private final Set<ChunkCoordPair> processedColumns = new ObjectOpenHashSet<ChunkCoordPair>();
    private final List<ColumnData> cachedPendingSolving = new ArrayList<ColumnData>();
    private final Stack<ColumnData> cachedSolvingStack = new Stack();
    private final Set<ColumnData> cachedChecking = new ObjectOpenHashSet<ColumnData>();
    private final Set<ColumnData> cachedSolved = new ObjectOpenHashSet<ColumnData>();

    public ColumnPreTransformConversionHandler(ColumnConversionHandler delegate, ChunkerWorld chunkerWorld) {
        this.delegate = delegate;
        this.incompleteRegions.addAll(chunkerWorld.getRegions());
    }

    protected void trySolve(ColumnData input, Set<ColumnData> output) {
        this.cachedSolvingStack.push(input);
        while (!this.cachedSolvingStack.isEmpty()) {
            ColumnData current = this.cachedSolvingStack.pop();
            if (!current.getPendingCheckEdges().isEmpty()) {
                this.cachedChecking.clear();
                break;
            }
            this.cachedChecking.add(current);
            for (ColumnData value : current.getRequiredColumns().values()) {
                if (value == null || !this.cachedChecking.add(value)) continue;
                this.cachedSolvingStack.push(value);
            }
        }
        if (!this.cachedChecking.isEmpty()) {
            output.addAll(this.cachedChecking);
            this.cachedChecking.clear();
        }
        this.cachedSolvingStack.clear();
    }

    protected void processPendingSolve() {
        if (!this.cachedPendingSolving.isEmpty()) {
            for (ColumnData pendingSolve : this.cachedPendingSolving) {
                this.trySolve(pendingSolve, this.cachedSolved);
            }
            this.cachedPendingSolving.clear();
            if (!this.cachedSolved.isEmpty()) {
                this.transformCluster(this.cachedSolved);
                for (ColumnData value : this.cachedSolved) {
                    RegionCoordPair regionCoordPair = value.getPosition().getRegion();
                    Map<ChunkCoordPair, ColumnData> region = this.pending.get(regionCoordPair);
                    region.remove(value.getPosition());
                    if (!region.isEmpty() || this.incompleteRegions.contains(regionCoordPair) || this.pending.remove(regionCoordPair) == null) continue;
                    this.delegate.flushRegion(regionCoordPair);
                }
                this.cachedSolved.clear();
            }
        }
    }

    protected boolean solveEdge(ChunkCoordPair position, Edge edge, @Nullable ColumnData columnData) {
        Edge opposite = edge.getOpposite();
        ChunkCoordPair relativePosition = edge.getRelative(position);
        RegionCoordPair relativePositionRegion = relativePosition.getRegion();
        Map<ChunkCoordPair, ColumnData> region = this.pending.get(relativePosition.getRegion());
        ColumnData relativeData = null;
        if (region != null) {
            relativeData = region.get(relativePosition);
        }
        if (relativeData == null) {
            return !this.incompleteRegions.contains(relativePositionRegion);
        }
        if (columnData != null && columnData.getRequiredColumns().containsKey((Object)edge)) {
            relativeData.getRequiredColumns().put(opposite, columnData);
            columnData.getRequiredColumns().put(edge, relativeData);
        }
        if (relativeData.getPendingCheckEdges().remove((Object)opposite)) {
            if (columnData != null && relativeData.getRequiredColumns().containsKey((Object)opposite)) {
                relativeData.getRequiredColumns().put(opposite, columnData);
                columnData.getRequiredColumns().put(edge, relativeData);
            }
            if (relativeData.getRequiredColumns().isEmpty() && relativeData.getPendingCheckEdges().isEmpty()) {
                region.remove(relativePosition);
                relativeData.submit(this.delegate);
                if (region.isEmpty() && !this.incompleteRegions.contains(relativePositionRegion) && this.pending.remove(relativePositionRegion) != null) {
                    this.delegate.flushRegion(relativePositionRegion);
                }
            } else if (relativeData.getPendingCheckEdges().isEmpty()) {
                this.cachedPendingSolving.add(relativeData);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void solveColumn(ColumnData columnData) {
        ChunkCoordPair position = columnData.getPosition();
        ColumnPreTransformConversionHandler columnPreTransformConversionHandler = this;
        synchronized (columnPreTransformConversionHandler) {
            Preconditions.checkArgument(this.processedColumns.add(position), "Duplicate chunk processed, unable to solve.");
            columnData.getPendingCheckEdges().removeIf(edge -> this.solveEdge(position, (Edge)((Object)edge), columnData));
            if (columnData.getRequiredColumns().isEmpty() && columnData.getPendingCheckEdges().isEmpty()) {
                columnData.submit(this.delegate);
            } else {
                Map region = this.pending.computeIfAbsent(position.getRegion(), ignored -> new Object2ReferenceOpenHashMap());
                region.put(position, columnData);
                if (columnData.getPendingCheckEdges().isEmpty()) {
                    this.cachedPendingSolving.add(columnData);
                }
            }
            this.processPendingSolve();
        }
    }

    @Override
    public void convertColumn(ChunkerColumn column) {
        Set<Edge> outgoingEdges = column.getRequiredPreTransformEdges();
        EnumSet<Edge> pendingCheckEdges = EnumSet.allOf(Edge.class);
        EnumMap<Edge, ColumnData> requiredColumns = new EnumMap<Edge, ColumnData>(Edge.class);
        if (outgoingEdges != null) {
            for (Edge edge : outgoingEdges) {
                requiredColumns.put(edge, null);
            }
        }
        ColumnData columnData = new ColumnData(column.getPosition(), column, requiredColumns, pendingCheckEdges);
        this.solveColumn(columnData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushRegion(RegionCoordPair regionCoordPair) {
        ColumnPreTransformConversionHandler columnPreTransformConversionHandler = this;
        synchronized (columnPreTransformConversionHandler) {
            this.incompleteRegions.remove(regionCoordPair);
            Map<ChunkCoordPair, ColumnData> region = this.pending.get(regionCoordPair);
            if (region == null) {
                this.delegate.flushRegion(regionCoordPair);
                return;
            }
            region.entrySet().removeIf(entry -> {
                ColumnData columnData = (ColumnData)entry.getValue();
                ChunkCoordPair chunkCoordPair = (ChunkCoordPair)entry.getKey();
                columnData.getPendingCheckEdges().removeIf(edge -> regionCoordPair.isInside(edge.getRelative(chunkCoordPair)));
                columnData.getRequiredColumns().entrySet().removeIf(edge -> edge.getValue() == null && regionCoordPair.isInside(((Edge)((Object)((Object)((Object)edge.getKey())))).getRelative(chunkCoordPair)));
                if (columnData.getRequiredColumns().isEmpty() && columnData.getPendingCheckEdges().isEmpty()) {
                    this.cachedSolved.add(columnData);
                    return true;
                }
                return false;
            });
            if (!this.cachedSolved.isEmpty()) {
                this.transformCluster(this.cachedSolved);
                this.cachedSolved.clear();
            }
            this.markAsEmpty(regionCoordPair.getChunk(0, 0), EnumSet.of(Edge.NEGATIVE_X, Edge.NEGATIVE_Z));
            this.markAsEmpty(regionCoordPair.getChunk(31, 0), EnumSet.of(Edge.POSITIVE_X, Edge.NEGATIVE_Z));
            this.markAsEmpty(regionCoordPair.getChunk(0, 31), EnumSet.of(Edge.NEGATIVE_X, Edge.POSITIVE_Z));
            this.markAsEmpty(regionCoordPair.getChunk(31, 31), EnumSet.of(Edge.POSITIVE_X, Edge.POSITIVE_Z));
            for (int x = 1; x < 31; ++x) {
                this.markAsEmpty(regionCoordPair.getChunk(x, 0), EnumSet.of(Edge.NEGATIVE_Z));
                this.markAsEmpty(regionCoordPair.getChunk(x, 31), EnumSet.of(Edge.POSITIVE_Z));
            }
            for (int z = 1; z < 31; ++z) {
                this.markAsEmpty(regionCoordPair.getChunk(0, z), EnumSet.of(Edge.NEGATIVE_X));
                this.markAsEmpty(regionCoordPair.getChunk(31, z), EnumSet.of(Edge.POSITIVE_X));
            }
            if (region.isEmpty() && this.pending.remove(regionCoordPair) != null) {
                this.delegate.flushRegion(regionCoordPair);
            }
        }
    }

    protected void markAsEmpty(ChunkCoordPair chunkCoordPair, EnumSet<Edge> checkedEdges) {
        if (this.processedColumns.contains(chunkCoordPair)) {
            return;
        }
        checkedEdges.forEach(edge -> this.solveEdge(chunkCoordPair, (Edge)((Object)edge), null));
        this.processPendingSolve();
    }

    protected void handlePreTransform(ChunkerColumn column, Map<Edge, ColumnData> requiredColumns) {
        Object2ObjectOpenHashMap<Edge, ChunkerColumn> columns = new Object2ObjectOpenHashMap<Edge, ChunkerColumn>(requiredColumns.size());
        requiredColumns.forEach((edge, columnData) -> {
            if (columnData == null) {
                return;
            }
            columns.put((Edge)((Object)edge), columnData.getColumn());
        });
        column.preTransform(columns);
    }

    protected void transformCluster(Collection<ColumnData> cluster) {
        for (ColumnData pendingData : cluster) {
            this.handlePreTransform(pendingData.getColumn(), pendingData.getRequiredColumns());
        }
        for (ColumnData pendingData : cluster) {
            pendingData.submit(this.delegate);
        }
    }

    @Override
    public void flushColumns() {
        Task.async("Submitting remaining columns", TaskWeight.NORMAL, () -> {
            ColumnPreTransformConversionHandler columnPreTransformConversionHandler = this;
            synchronized (columnPreTransformConversionHandler) {
                for (Map.Entry<RegionCoordPair, Map<ChunkCoordPair, ColumnData>> region : this.pending.entrySet()) {
                    this.transformCluster(region.getValue().values());
                }
                this.pending.clear();
            }
        }).then("Calling delegate flushColumns", TaskWeight.NORMAL, this.delegate::flushColumns);
    }

    protected static class ColumnData {
        private final ChunkCoordPair position;
        private final ChunkerColumn column;
        private final Map<Edge, ColumnData> requiredColumns;
        private final EnumSet<Edge> pendingCheckEdges;
        private boolean submitted;

        public ColumnData(ChunkCoordPair position, ChunkerColumn column, Map<Edge, ColumnData> requiredColumns, EnumSet<Edge> pendingCheckEdges) {
            this.position = position;
            this.column = column;
            this.requiredColumns = requiredColumns;
            this.pendingCheckEdges = pendingCheckEdges;
        }

        public ChunkCoordPair getPosition() {
            return this.position;
        }

        public ChunkerColumn getColumn() {
            return this.column;
        }

        public Map<Edge, ColumnData> getRequiredColumns() {
            return this.requiredColumns;
        }

        public EnumSet<Edge> getPendingCheckEdges() {
            return this.pendingCheckEdges;
        }

        public void submit(ColumnConversionHandler delegate) {
            Preconditions.checkArgument(!this.submitted, "Duplicate submission occurred for column!");
            this.submitted = true;
            delegate.convertColumn(this.column);
        }

        public String toString() {
            return "ColumnData{position=" + String.valueOf(this.position) + ",column=" + String.valueOf(this.column) + ", requiredColumns=" + String.valueOf(this.requiredColumns.keySet()) + ", pendingCheckEdges=" + String.valueOf(this.pendingCheckEdges) + "}";
        }
    }
}

