/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.handlers.pipeline;

import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.LevelConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class Pipeline {
    private final LevelConversionHandler base;
    private Function<LevelConversionHandler, LevelConversionHandler> levelConversionTransformer;
    private BiFunction<WorldConversionHandler, ChunkerLevel, WorldConversionHandler> worldConversionTransformer;
    private BiFunction<ColumnConversionHandler, ChunkerWorld, ColumnConversionHandler> columnConversionTransformer;

    public Pipeline(LevelConversionHandler base) {
        this.base = base;
    }

    @SafeVarargs
    @Nullable
    protected static <T> Function<T, T> compose(Function<T, T> ... handlers) {
        if (handlers.length == 0) {
            return null;
        }
        Function<T, T> function = handlers[0];
        for (int i = 1; i < handlers.length; ++i) {
            function = function.andThen(handlers[i]);
        }
        return function;
    }

    @SafeVarargs
    @Nullable
    protected static <T, U> BiFunction<T, U, T> compose(BiFunction<T, U, T> ... handlers) {
        if (handlers.length == 0) {
            return null;
        }
        BiFunction<Object, Object, Object> function = handlers[0];
        for (int i = 1; i < handlers.length; ++i) {
            BiFunction previous = function;
            BiFunction current = handlers[i];
            function = (t, u) -> current.apply(previous.apply(t, u), u);
        }
        return function;
    }

    @SafeVarargs
    public final void levelHandlers(Function<LevelConversionHandler, LevelConversionHandler> ... handlers) {
        this.levelConversionTransformer = Pipeline.compose(handlers);
    }

    @SafeVarargs
    public final void worldHandlers(BiFunction<WorldConversionHandler, ChunkerLevel, WorldConversionHandler> ... handlers) {
        this.worldConversionTransformer = Pipeline.compose(handlers);
    }

    @SafeVarargs
    public final void columnHandlers(BiFunction<ColumnConversionHandler, ChunkerWorld, ColumnConversionHandler> ... handlers) {
        this.columnConversionTransformer = Pipeline.compose(handlers);
    }

    @Nullable
    public LevelConversionHandler build() {
        if (this.base == null) {
            return null;
        }
        LevelConversionHandler delegate = this.levelConversionTransformer != null ? this.levelConversionTransformer.apply(this.base) : this.base;
        return new PipelineLevelConversionHandler(delegate);
    }

    class PipelineLevelConversionHandler
    implements LevelConversionHandler {
        protected final LevelConversionHandler delegate;

        public PipelineLevelConversionHandler(LevelConversionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public Task<WorldConversionHandler> convertLevel(ChunkerLevel level) {
            return Task.asyncUnwrap("Running level middleware", TaskWeight.NORMAL, () -> this.delegate.convertLevel(level).then("Applying level pipeline", TaskWeight.NONE, base -> {
                if (base == null) {
                    return null;
                }
                WorldConversionHandler delegate = Pipeline.this.worldConversionTransformer != null ? Pipeline.this.worldConversionTransformer.apply((WorldConversionHandler)base, level) : base;
                return new PipelineWorldConversionHandler(delegate);
            }));
        }

        @Override
        public void flushLevel() {
            Task.async("Running level middleware", TaskWeight.NORMAL, this.delegate::flushLevel);
        }
    }

    class PipelineWorldConversionHandler
    implements WorldConversionHandler {
        protected final WorldConversionHandler delegate;

        public PipelineWorldConversionHandler(WorldConversionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public Task<ColumnConversionHandler> convertWorld(ChunkerWorld world) {
            return Task.asyncUnwrap("Running world middleware", TaskWeight.NORMAL, () -> this.delegate.convertWorld(world).then("Applying world pipeline", TaskWeight.NONE, base -> {
                if (base == null) {
                    return null;
                }
                ColumnConversionHandler delegate = Pipeline.this.columnConversionTransformer != null ? Pipeline.this.columnConversionTransformer.apply((ColumnConversionHandler)base, world) : base;
                return new PipelineColumnConversionHandler(delegate);
            }));
        }

        @Override
        public void flushWorld(ChunkerWorld chunkerWorld) {
            Task.asyncConsume("Running world middleware", TaskWeight.NORMAL, this.delegate::flushWorld, chunkerWorld);
        }

        @Override
        public void flushWorlds() {
            Task.async("Running world middleware", TaskWeight.NORMAL, this.delegate::flushWorlds);
        }
    }

    static class PipelineColumnConversionHandler
    implements ColumnConversionHandler {
        protected final ColumnConversionHandler delegate;

        public PipelineColumnConversionHandler(ColumnConversionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void convertColumn(ChunkerColumn column) {
            Task.asyncConsume("Running column middleware", TaskWeight.NORMAL, this.delegate::convertColumn, column);
        }

        @Override
        public void flushRegion(RegionCoordPair regionCoordPair) {
            Task.asyncConsume("Running column middleware", TaskWeight.NORMAL, this.delegate::flushRegion, regionCoordPair);
        }

        @Override
        public void flushColumns() {
            Task.async("Running column middleware", TaskWeight.NORMAL, this.delegate::flushColumns);
        }
    }
}

