/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.preview;

import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.preview.PreviewColumnWriter;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PreviewWorldWriter
implements WorldWriter {
    private final List<WorldData> worldDataList = Collections.synchronizedList(new ArrayList(4));
    private final File outputFolder;

    public PreviewWorldWriter(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    @Override
    public ColumnWriter writeWorld(ChunkerWorld chunkerWorld) {
        WorldData worldData = new WorldData();
        worldData.dimension = chunkerWorld.getDimension();
        this.worldDataList.add(worldData);
        return new PreviewColumnWriter(this.outputFolder, worldData);
    }

    @Override
    public void flushWorlds() throws IOException {
        File outputFile = new File(this.outputFolder, "map.bin");
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
             DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
            Writer writer = Writer.toLittleEndianWriter(writerStream);
            writer.writeInt(this.worldDataList.size());
            for (WorldData worldData : this.worldDataList) {
                writer.writeByte(worldData.dimension.ordinal());
                writer.writeInt(worldData.minX);
                writer.writeInt(worldData.minZ);
                writer.writeInt(worldData.maxX);
                writer.writeInt(worldData.maxZ);
                writer.writeInt(worldData.regionToPresentChunks.size());
                for (Map.Entry<RegionCoordPair, Set<ChunkCoordPair>> entry : worldData.regionToPresentChunks.entrySet()) {
                    writer.writeInt(entry.getKey().regionX());
                    writer.writeInt(entry.getKey().regionZ());
                    BitSet presentChunks = new BitSet(1024);
                    for (ChunkCoordPair pos : entry.getValue()) {
                        presentChunks.set(pos.to10BitIndex(), true);
                    }
                    byte[] bitSet = presentChunks.toByteArray();
                    writer.writeBytes(bitSet);
                    for (int i = bitSet.length; i < 128; ++i) {
                        writer.writeByte(0);
                    }
                }
            }
        }
    }

    public static class WorldData {
        public final Map<RegionCoordPair, Set<ChunkCoordPair>> regionToPresentChunks = new ConcurrentHashMap<RegionCoordPair, Set<ChunkCoordPair>>();
        public int minX = Integer.MAX_VALUE;
        public int minZ = Integer.MAX_VALUE;
        public int maxX = Integer.MIN_VALUE;
        public int maxZ = Integer.MIN_VALUE;
        public Dimension dimension;
    }
}

