/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_21_9.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.v1_21_9.reader.WorldReader;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelReader
extends com.hivemc.chunker.conversion.encoding.java.v1_21_6.reader.LevelReader {
    public LevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        super(inputDirectory, inputVersion, converter);
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (targetName.equals("AutumnDrop2025")) {
            return true;
        }
        return super.readCustomLevelSetting(root, targetName, type);
    }

    @Override
    protected CompoundTag prepareNBTForLevelSettings(CompoundTag level) throws Exception {
        level = super.prepareNBTForLevelSettings(level);
        if ((level = level.clone()).contains("spawn")) {
            CompoundTag spawnTag = (CompoundTag)level.remove("spawn");
            if (spawnTag.contains("pos")) {
                int[] position = spawnTag.getIntArray("pos");
                level.put("SpawnX", position[0]);
                level.put("SpawnY", position[1]);
                level.put("SpawnZ", position[2]);
            }
            if (spawnTag.contains("pitch")) {
                level.put("SpawnPitch", spawnTag.getFloat("pitch"));
            }
            if (spawnTag.contains("yaw")) {
                level.put("SpawnYaw", spawnTag.getFloat("yaw"));
            }
            if (spawnTag.contains("dimension")) {
                level.put("SpawnDimension", spawnTag.getString("dimension"));
            }
        }
        if (level.contains("world_border")) {
            CompoundTag worldBorderTag = (CompoundTag)level.remove("world_border");
            if (worldBorderTag.contains("center_x")) {
                level.put("BorderCenterX", worldBorderTag.getDouble("center_x"));
            }
            if (worldBorderTag.contains("center_z")) {
                level.put("BorderCenterZ", worldBorderTag.getDouble("center_z"));
            }
            if (worldBorderTag.contains("size")) {
                level.put("BorderSize", worldBorderTag.getDouble("size"));
            }
            if (worldBorderTag.contains("lerp_time")) {
                level.put("BorderSizeLerpTime", worldBorderTag.getLong("lerp_time"));
            }
            if (worldBorderTag.contains("lerp_target")) {
                level.put("BorderSizeLerpTarget", worldBorderTag.getDouble("lerp_target"));
            }
            if (worldBorderTag.contains("safe_zone")) {
                level.put("BorderSafeZone", worldBorderTag.getDouble("safe_zone"));
            }
            if (worldBorderTag.contains("damage_per_block")) {
                level.put("BorderDamagePerBlock", worldBorderTag.getDouble("damage_per_block"));
            }
            if (worldBorderTag.contains("warning_blocks")) {
                level.put("BorderWarningBlocks", (double)worldBorderTag.getInt("warning_blocks"));
            }
            if (worldBorderTag.contains("warning_time")) {
                level.put("BorderWarningTime", (double)worldBorderTag.getInt("warning_time"));
            }
        }
        return level;
    }

    @Override
    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new WorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }
}

