/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_18.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.util.PaletteUtil;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.TagWithName;
import com.hivemc.chunker.nbt.tags.array.LongArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.util.ArrayList;
import java.util.List;

public class ChunkWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_17.writer.ChunkWriter {
    public ChunkWriter(Converter converter, JavaResolvers resolvers, Dimension dimension, ChunkerColumn chunkerColumn) {
        super(converter, resolvers, dimension, chunkerColumn);
    }

    @Override
    protected List<Task<Void>> createChunkTasks(ChunkerChunk chunkerChunk, List<TagWithName<?>> outputs) {
        List<Task<Void>> tasks = super.createChunkTasks(chunkerChunk, outputs);
        tasks.add(Task.async("Writing Biomes", TaskWeight.MEDIUM, () -> this.writeBiomes(chunkerChunk, outputs)));
        return tasks;
    }

    @Override
    protected void writeBlockPalette(ChunkerChunk chunk, List<TagWithName<?>> output) {
        ListTag keys;
        ArrayList temp = new ArrayList(1);
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        int keyCount = 1;
        if (!palette.isEmpty()) {
            keyCount = palette.getKeyCount();
            keys = new ListTag(TagType.COMPOUND, keyCount);
            for (int i = 0; i < keyCount; ++i) {
                ChunkerBlockIdentifier blockIdentifier = palette.getKey(i, ChunkerBlockIdentifier.AIR);
                keys.add(this.resolvers.writeBlock(blockIdentifier));
            }
        } else {
            keys = new ListTag(TagType.COMPOUND, 1);
            keys.add(this.resolvers.writeBlock(ChunkerBlockIdentifier.AIR));
        }
        temp.add(new TagWithName("palette", keys));
        short[][][] values = null;
        if (palette instanceof ShortBasedPalette) {
            ShortBasedPalette shortBasedPalette = (ShortBasedPalette)palette;
            values = shortBasedPalette.getValues();
        }
        this.writeBlockPaletteValues(keyCount, values, temp);
        CompoundTag blockStates = new CompoundTag(temp.size());
        for (TagWithName tagWithName : temp) {
            if (tagWithName == null) continue;
            blockStates.put(tagWithName.name(), (Tag<?>)tagWithName.tag());
        }
        output.add(new TagWithName<CompoundTag>("block_states", blockStates));
    }

    @Override
    protected void writeBlockPaletteValues(int keyCount, short[][][] values, List<TagWithName<?>> output) {
        long[] encodedValues = PaletteUtil.writePaletteValues1_16(4, 16, keyCount, values);
        output.add(new TagWithName<LongArrayTag>("data", new LongArrayTag(encodedValues)));
    }

    protected void writeBiomes(ChunkerChunk chunkerChunk, List<TagWithName<?>> outputs) {
        ListTag<StringTag, String> keys;
        if (this.chunkerColumn.getBiomes() == null) {
            return;
        }
        boolean cavesAndCliffs = this.converter.level().map(level -> level.getSettings().CavesAndCliffs).orElse(false);
        Palette<ChunkerBiome> biomePalette = this.chunkerColumn.getBiomes().as4X4Palette(chunkerChunk.getY() + (cavesAndCliffs ? 4 : 0));
        CompoundTag biomes = new CompoundTag(2);
        int keyCount = 1;
        if (biomePalette != null && !biomePalette.isEmpty()) {
            keyCount = biomePalette.getKeyCount();
            keys = new ListTag<StringTag, String>(TagType.STRING, keyCount);
            for (int i = 0; i < keyCount; ++i) {
                ChunkerBiome chunkerBiome = biomePalette.getKey(i, null);
                if (chunkerBiome == null) {
                    chunkerBiome = this.resolvers.getFallbackBiome(this.dimension);
                }
                keys.add(new StringTag(this.resolvers.writeBiome(chunkerBiome, this.dimension)));
            }
        } else {
            keys = new ListTag<StringTag, String>(TagType.STRING, 1);
            keys.add(new StringTag(this.resolvers.writeBiome(this.resolvers.getFallbackBiome(this.dimension), this.dimension)));
        }
        biomes.put("palette", keys);
        if (keyCount > 1) {
            short[][][] values = null;
            if (biomePalette instanceof ShortBasedPalette) {
                ShortBasedPalette shortBasedPalette = (ShortBasedPalette)biomePalette;
                values = shortBasedPalette.getValues();
            }
            long[] encodedValues = PaletteUtil.writePaletteValues1_16(1, 4, keyCount, values);
            biomes.put("data", new LongArrayTag(encodedValues));
        }
        outputs.add(new TagWithName<CompoundTag>("biomes", biomes));
    }
}

