/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_18.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaChunkReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.util.PaletteUtil;
import com.hivemc.chunker.conversion.encoding.java.v1_18.reader.ChunkReader;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.biome.layout.ChunkerClusterPaletteBasedBiomes;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.ArrayList;
import java.util.List;

public class ColumnReader
extends com.hivemc.chunker.conversion.encoding.java.v1_17.reader.ColumnReader {
    public ColumnReader(Converter converter, JavaResolvers resolvers, Dimension dimension, ChunkCoordPair columnCoords, CompoundTag columnNBT) {
        super(converter, resolvers, dimension, columnCoords, columnNBT);
    }

    @Override
    protected void readBiomes(ChunkerColumn column) {
        ListTag sections = this.columnNBT.getList("sections", CompoundTag.class, null);
        if (sections != null) {
            ArrayList<Palette<ChunkerBiome>> chunks = new ArrayList<Palette<ChunkerBiome>>(sections.size());
            for (CompoundTag section : sections) {
                try {
                    section = section.getCompound("biomes", section);
                    long[] values = section.getLongArray("data", null);
                    List keys = section.getListValues("palette", StringTag.class, null);
                    if (keys == null || keys.isEmpty()) {
                        chunks.add(EmptyPalette.instance(4));
                        continue;
                    }
                    ArrayList<ChunkerBiome> biomeKeys = new ArrayList<ChunkerBiome>(keys.size());
                    for (String key : keys) {
                        biomeKeys.add(this.resolvers.readBiome(key, this.dimension));
                    }
                    if (values == null || biomeKeys.size() == 1) {
                        chunks.add(new SingleValuePalette<ChunkerBiome>(4, (ChunkerBiome)biomeKeys.get(0)));
                        continue;
                    }
                    chunks.add(new ShortBasedPalette(biomeKeys, PaletteUtil.readPaletteValues(1, 4, keys.size(), values)));
                }
                catch (Exception e) {
                    this.converter.logNonFatalException(e);
                    chunks.add(EmptyPalette.instance(4));
                }
            }
            column.setBiomes(new ChunkerClusterPaletteBasedBiomes(chunks));
            return;
        }
        super.readBiomes(column);
    }

    @Override
    protected void readBlockEntities(ChunkerColumn column) {
        ListTag blockEntities = this.columnNBT.getList("block_entities", CompoundTag.class, null);
        if (blockEntities != null) {
            for (CompoundTag blockEntityTag : blockEntities) {
                try {
                    this.readBlockEntity(column, blockEntityTag);
                }
                catch (Exception e) {
                    this.converter.logNonFatalException(new Exception("Failed to process BlockEntity " + String.valueOf(blockEntityTag), e));
                }
            }
        } else {
            super.readBlockEntities(column);
        }
    }

    @Override
    public JavaChunkReader createChunkReader(ChunkerColumn column, ChunkerChunk chunk) {
        return new ChunkReader(this.converter, this.resolvers, column, chunk);
    }
}

