/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_17.writer;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.encoding.java.v1_17.writer.WorldWriter;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.io.File;
import java.io.IOException;

public class LevelWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_16.writer.LevelWriter {
    public LevelWriter(File outputFolder, Version version, Converter converter) {
        super(outputFolder, version, converter);
    }

    @Override
    public void writeCustomLevelSetting(ChunkerLevelSettings chunkerLevelSettings, CompoundTag output, String targetName, Object value) {
        if (targetName.equals("CavesAndCliffs")) {
            if (((Boolean)value).booleanValue() && !this.converter.shouldAllowNBTCopying()) {
                ListTag<StringTag, Object> enabled;
                File directory = new File(this.outputFolder, "datapacks");
                if (!directory.isDirectory()) {
                    directory.mkdirs();
                }
                File outputFile = new File(directory, "CavesAndCliffsHeightPack.zip");
                try {
                    Resources.asByteSource(Resources.getResource("java/CavesAndCliffsHeightPack.zip")).copyTo(Files.asByteSink(outputFile, new FileWriteMode[0]));
                }
                catch (IOException e) {
                    this.converter.logNonFatalException(e);
                }
                CompoundTag dataPacks = output.getOrCreateCompound("DataPacks");
                if (!dataPacks.contains("Enabled")) {
                    dataPacks.put("Enabled", new ListTag<StringTag, String>(TagType.STRING, 1));
                }
                if (!(enabled = dataPacks.getList("Enabled", StringTag.class)).contains("vanilla")) {
                    enabled.add(new StringTag("vanilla"));
                }
                if (!enabled.contains("file/" + outputFile.getName())) {
                    enabled.add(new StringTag("file/" + outputFile.getName()));
                }
            }
            return;
        }
        super.writeCustomLevelSetting(chunkerLevelSettings, output, targetName, value);
    }

    @Override
    public JavaWorldWriter createWorldWriter() {
        return new WorldWriter(this.outputFolder, this.converter, this.resolvers);
    }
}

