/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_13.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.JavaReaderPreTransformManager;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolversBuilder;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.JavaBlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.JavaEntityResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.JavaPaintingMotiveResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.identifier.JavaBlockIdentifierResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.identifier.JavaItemIdentifierResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack.JavaItemStackResolver;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaWorldWriter;
import com.hivemc.chunker.conversion.encoding.java.base.writer.pretransform.JavaWriterPreTransformManager;
import com.hivemc.chunker.conversion.encoding.java.v1_13.writer.WorldWriter;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.io.File;

public class LevelWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_11.writer.LevelWriter {
    public LevelWriter(File outputFolder, Version version, Converter converter) {
        super(outputFolder, version, converter);
    }

    @Override
    public void writeCustomLevelSetting(ChunkerLevelSettings chunkerLevelSettings, CompoundTag output, String targetName, Object value) {
        if (value instanceof ChunkerGeneratorType) {
            ChunkerGeneratorType generatorType = (ChunkerGeneratorType)((Object)value);
            if (!this.converter.shouldAllowNBTCopying() && generatorType == ChunkerGeneratorType.CUSTOM) {
                generatorType = ChunkerGeneratorType.VOID;
            }
            switch (generatorType) {
                case NORMAL: {
                    output.put("generatorName", "default");
                    output.put("generatorVersion", 0);
                    return;
                }
                case FLAT: {
                    output.put("generatorName", "flat");
                    output.put("generatorVersion", 0);
                    return;
                }
                case VOID: {
                    output.put("generatorName", "flat");
                    output.put("generatorVersion", 0);
                    CompoundTag generatorOptions = new CompoundTag(2);
                    generatorOptions.put("biome", this.resolvers.writeBiome(ChunkerBiome.ChunkerVanillaBiome.PLAINS, Dimension.OVERWORLD));
                    ListTag layers = new ListTag(TagType.COMPOUND, 1);
                    CompoundTag airLayer = new CompoundTag(2);
                    airLayer.put("block", "minecraft:air");
                    airLayer.put("height", (byte)1);
                    layers.add(airLayer);
                    generatorOptions.put("layers", layers);
                    output.put("generatorOptions", generatorOptions);
                    return;
                }
                case CUSTOM: {
                    return;
                }
            }
        }
        super.writeCustomLevelSetting(chunkerLevelSettings, output, targetName, value);
    }

    @Override
    public JavaWorldWriter createWorldWriter() {
        return new WorldWriter(this.outputFolder, this.converter, this.resolvers);
    }

    @Override
    public JavaResolversBuilder buildResolvers(Converter converter) {
        Version version = this.getVersion();
        return super.buildResolvers(converter).entityResolverConstructor(resolvers -> new JavaEntityResolver(version, (JavaResolvers)resolvers)).blockEntityResolverConstructor(resolvers -> new JavaBlockEntityResolver(version, (JavaResolvers)resolvers)).itemStackResolverConstructor(JavaItemStackResolver::new).paintingMotiveResolver(new JavaPaintingMotiveResolver(version)).itemIdentifierResolver(new JavaItemIdentifierResolver(converter, version, this.isReader())).blockIdentifierResolver(new JavaBlockIdentifierResolver(converter, version, this.isReader(), converter.shouldAllowCustomIdentifiers())).preTransformManager(this.isReader() ? new JavaReaderPreTransformManager(version) : new JavaWriterPreTransformManager(version));
    }
}

