/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_13.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.util.PaletteUtil;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.TagWithName;
import com.hivemc.chunker.nbt.tags.array.LongArrayTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.util.List;

public class ChunkWriter
extends com.hivemc.chunker.conversion.encoding.java.v1_11.writer.ChunkWriter {
    public ChunkWriter(Converter converter, JavaResolvers resolvers, Dimension dimension, ChunkerColumn chunkerColumn) {
        super(converter, resolvers, dimension, chunkerColumn);
    }

    @Override
    protected void writeBlockPalette(ChunkerChunk chunk, List<TagWithName<?>> output) {
        ListTag keys;
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        int keyCount = 1;
        if (!palette.isEmpty()) {
            keyCount = palette.getKeyCount();
            keys = new ListTag(TagType.COMPOUND, keyCount);
            for (int i = 0; i < keyCount; ++i) {
                ChunkerBlockIdentifier blockIdentifier = palette.getKey(i, ChunkerBlockIdentifier.AIR);
                keys.add(this.resolvers.writeBlock(blockIdentifier));
            }
        } else {
            keys = new ListTag(TagType.COMPOUND, 1);
            keys.add(this.resolvers.writeBlock(ChunkerBlockIdentifier.AIR));
        }
        output.add(new TagWithName("Palette", keys));
        short[][][] values = null;
        if (palette instanceof ShortBasedPalette) {
            ShortBasedPalette shortBasedPalette = (ShortBasedPalette)palette;
            values = shortBasedPalette.getValues();
        }
        this.writeBlockPaletteValues(keyCount, values, output);
    }

    protected void writeBlockPaletteValues(int keyCount, short[][][] values, List<TagWithName<?>> output) {
        long[] encodedValues = PaletteUtil.writePaletteValues1_13(4, 16, keyCount, values);
        output.add(new TagWithName<LongArrayTag>("BlockStates", new LongArrayTag(encodedValues)));
    }
}

