/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_13.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.JavaReaderPreTransformManager;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolversBuilder;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.JavaBlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.JavaEntityResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.JavaPaintingMotiveResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.identifier.JavaBlockIdentifierResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.identifier.JavaItemIdentifierResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack.JavaItemStackResolver;
import com.hivemc.chunker.conversion.encoding.java.base.writer.pretransform.JavaWriterPreTransformManager;
import com.hivemc.chunker.conversion.encoding.java.v1_13.reader.WorldReader;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelReader
extends com.hivemc.chunker.conversion.encoding.java.v1_11.reader.LevelReader {
    public LevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        super(inputDirectory, inputVersion, converter);
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (type == ChunkerGeneratorType.class) {
            String generatorName = root.getString("generatorName", null);
            if (generatorName == null) {
                return ChunkerGeneratorType.NORMAL;
            }
            if (generatorName.equals("default")) {
                return ChunkerGeneratorType.CUSTOM;
            }
            if (generatorName.equals("flat")) {
                Object generatorOptions = root.get("generatorOptions");
                if (generatorOptions == null) {
                    return ChunkerGeneratorType.FLAT;
                }
                if (!(generatorOptions instanceof CompoundTag)) {
                    return super.readCustomLevelSetting(root, targetName, type);
                }
                CompoundTag generatorOptionsCompound = (CompoundTag)generatorOptions;
                return this.inferGeneratorTypeFromLayers((Tag<?>)generatorOptionsCompound.get("layers"));
            }
            return ChunkerGeneratorType.CUSTOM;
        }
        return super.readCustomLevelSetting(root, targetName, type);
    }

    protected ChunkerGeneratorType inferGeneratorTypeFromLayers(@Nullable Tag<?> layers) {
        if (layers == null) {
            return ChunkerGeneratorType.FLAT;
        }
        if (!(layers instanceof ListTag)) {
            return ChunkerGeneratorType.VOID;
        }
        ListTag layersList = (ListTag)layers;
        boolean air = true;
        for (Tag layerTag : layersList) {
            CompoundTag layerCompoundTag;
            String blockIdentifier;
            if (!(layerTag instanceof CompoundTag) || (blockIdentifier = (layerCompoundTag = (CompoundTag)layerTag).getString("block", "minecraft:air")).equals("minecraft:air")) continue;
            air = false;
        }
        if (air) {
            return ChunkerGeneratorType.VOID;
        }
        if (layersList.size() == 3 && ((CompoundTag)layersList.get(0)).getString("block", null).equals("minecraft:bedrock") && ((CompoundTag)layersList.get(1)).getString("block", null).equals("minecraft:dirt") && ((CompoundTag)layersList.get(2)).getString("block", null).equals("minecraft:grass_block")) {
            return ChunkerGeneratorType.FLAT;
        }
        return ChunkerGeneratorType.CUSTOM;
    }

    @Override
    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new WorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }

    @Override
    public JavaResolversBuilder buildResolvers(Converter converter) {
        Version version = this.getVersion();
        return super.buildResolvers(converter).entityResolverConstructor(resolvers -> new JavaEntityResolver(version, (JavaResolvers)resolvers)).blockEntityResolverConstructor(resolvers -> new JavaBlockEntityResolver(version, (JavaResolvers)resolvers)).itemStackResolverConstructor(JavaItemStackResolver::new).paintingMotiveResolver(new JavaPaintingMotiveResolver(version)).itemIdentifierResolver(new JavaItemIdentifierResolver(converter, version, this.isReader())).blockIdentifierResolver(new JavaBlockIdentifierResolver(converter, version, this.isReader(), converter.shouldAllowCustomIdentifiers())).preTransformManager(this.isReader() ? new JavaReaderPreTransformManager(version) : new JavaWriterPreTransformManager(version));
    }
}

