/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.v1_13.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.util.PaletteUtil;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.util.ArrayList;

public class ChunkReader
extends com.hivemc.chunker.conversion.encoding.java.v1_11.reader.ChunkReader {
    public ChunkReader(Converter converter, JavaResolvers resolvers, ChunkerColumn column, ChunkerChunk chunk) {
        super(converter, resolvers, column, chunk);
    }

    @Override
    public void readPalette(CompoundTag nbt) {
        ListTag keysList = nbt.getList("Palette", CompoundTag.class, null);
        long[] encodedValues = nbt.getLongArray("BlockStates", null);
        if (keysList == null) {
            super.readPalette(nbt);
            return;
        }
        ArrayList<ChunkerBlockIdentifier> keys = new ArrayList<ChunkerBlockIdentifier>(keysList.size());
        for (CompoundTag key : keysList) {
            keys.add(this.resolvers.readBlock(key));
        }
        if (keys.isEmpty()) {
            this.chunk.setPalette(EmptyPalette.chunk());
            return;
        }
        if (keys.size() == 1 || encodedValues == null) {
            this.chunk.setPalette(SingleValuePalette.chunk((ChunkerBlockIdentifier)keys.iterator().next()));
            return;
        }
        short[][][] values = PaletteUtil.readPaletteValues(4, 16, keys.size(), encodedValues);
        this.chunk.setPalette(new ShortBasedPalette<ChunkerBlockIdentifier>(keys, values));
    }
}

