/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.util;

import org.jetbrains.annotations.Nullable;

public class PaletteUtil {
    public static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    public static final int MINIMUM_BITS_PER_ENTRY_BIOMES = 1;
    public static final int MINIMUM_BITS_PER_ENTRY_BLOCKS = 4;

    public static long[] writePaletteValues1_13(int minimumBitsPerEntry, int dimensionSize, int keyCount, short @Nullable [][][] values) {
        int bitsPerEntry = minimumBitsPerEntry;
        while (keyCount > 1 << bitsPerEntry) {
            ++bitsPerEntry;
        }
        long maxEntryValue = (1L << bitsPerEntry) - 1L;
        int valuesPerPalette = dimensionSize * dimensionSize * dimensionSize;
        int dimensionBitMask = dimensionSize - 1;
        int zDimensionBitShift = dimensionSize >> 2;
        int yDimensionBitShift = zDimensionBitShift + zDimensionBitShift;
        long[] encodedValues = new long[(int)Math.ceil((double)(valuesPerPalette * bitsPerEntry) / 64.0)];
        if (values != null) {
            for (int i = 0; i < valuesPerPalette; ++i) {
                int x = i & dimensionBitMask;
                int z = i >> zDimensionBitShift & dimensionBitMask;
                int y = i >> yDimensionBitShift & dimensionBitMask;
                short value = values[x][y][z];
                int bitIndex = i * bitsPerEntry;
                int startIndex = bitIndex / 64;
                int endIndex = ((i + 1) * bitsPerEntry - 1) / 64;
                int startBitSubIndex = bitIndex % 64;
                encodedValues[startIndex] = encodedValues[startIndex] & (maxEntryValue << startBitSubIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & maxEntryValue) << startBitSubIndex;
                if (startIndex == endIndex) continue;
                int endBitSubIndex = 64 - startBitSubIndex;
                encodedValues[endIndex] = encodedValues[endIndex] >> endBitSubIndex << endBitSubIndex | ((long)value & maxEntryValue) >> endBitSubIndex;
            }
        }
        return encodedValues;
    }

    public static long[] writePaletteValues1_16(int minimumBitsPerEntry, int dimensionSize, int keyCount, short @Nullable [][][] values) {
        int bitsPerEntry = minimumBitsPerEntry;
        while (keyCount > 1 << bitsPerEntry) {
            ++bitsPerEntry;
        }
        long maxEntryValue = (1L << bitsPerEntry) - 1L;
        int valuesPerPalette = dimensionSize * dimensionSize * dimensionSize;
        int dimensionBitMask = dimensionSize - 1;
        int zDimensionBitShift = dimensionSize >> 2;
        int yDimensionBitShift = zDimensionBitShift + zDimensionBitShift;
        char valuesPerLong = (char)(64 / bitsPerEntry);
        int magicIndex = 3 * (valuesPerLong - '\u0001');
        long divideMul = Integer.toUnsignedLong(MAGIC[magicIndex]);
        long divideAdd = Integer.toUnsignedLong(MAGIC[magicIndex + 1]);
        int divideShift = MAGIC[magicIndex + 2];
        long[] encodedValues = new long[(valuesPerPalette + valuesPerLong - 1) / valuesPerLong];
        if (values != null) {
            for (int i = 0; i < valuesPerPalette; ++i) {
                int x = i & dimensionBitMask;
                int z = i >> zDimensionBitShift & dimensionBitMask;
                int y = i >> yDimensionBitShift & dimensionBitMask;
                short value = values[x][y][z];
                int cellIndex = (int)((long)i * divideMul + divideAdd >> 32 >> divideShift);
                int bitIndex = (i - cellIndex * valuesPerLong) * bitsPerEntry;
                encodedValues[cellIndex] = encodedValues[cellIndex] & (maxEntryValue << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & maxEntryValue) << bitIndex;
            }
        }
        return encodedValues;
    }

    public static short[][][] readPaletteValues(int minimumBitsPerEntry, int dimensionSize, int keyCount, long[] encodedValues) {
        int bitsPerEntry = minimumBitsPerEntry;
        while (keyCount > 1 << bitsPerEntry) {
            ++bitsPerEntry;
        }
        int valuesPerPalette = dimensionSize * dimensionSize * dimensionSize;
        char valuesPerLong = (char)(64 / bitsPerEntry);
        double expectedLength = Math.ceil((double)valuesPerPalette / (double)valuesPerLong);
        if ((double)encodedValues.length != expectedLength) {
            bitsPerEntry = (int)Math.floor((double)(encodedValues.length * 64) / (double)valuesPerPalette);
            return PaletteUtil.readPaletteValues1_13(bitsPerEntry, dimensionSize, encodedValues);
        }
        return PaletteUtil.readPaletteValues1_16(bitsPerEntry, dimensionSize, encodedValues);
    }

    public static short[][][] readPaletteValues1_13(int bitsPerEntry, int dimensionSize, long[] encodedValues) {
        short[][][] output = new short[dimensionSize][dimensionSize][dimensionSize];
        int valuesPerPalette = dimensionSize * dimensionSize * dimensionSize;
        int dimensionBitMask = dimensionSize - 1;
        int zDimensionBitShift = dimensionSize >> 2;
        int yDimensionBitShift = zDimensionBitShift + zDimensionBitShift;
        long maxEntryValue = (1L << bitsPerEntry) - 1L;
        for (int i = 0; i < valuesPerPalette; ++i) {
            short value;
            int bitIndex = i * bitsPerEntry;
            int startIndex = bitIndex / 64;
            int endIndex = ((i + 1) * bitsPerEntry - 1) / 64;
            int startBitSubIndex = bitIndex % 64;
            if (startIndex == endIndex) {
                value = (short)(encodedValues[startIndex] >>> startBitSubIndex & maxEntryValue & 0xFFFFL);
            } else {
                int endBitSubIndex = 64 - startBitSubIndex;
                value = (short)((encodedValues[startIndex] >>> startBitSubIndex | encodedValues[endIndex] << endBitSubIndex) & maxEntryValue & 0xFFFFL);
            }
            int x = i & dimensionBitMask;
            int z = i >> zDimensionBitShift & dimensionBitMask;
            int y = i >> yDimensionBitShift & dimensionBitMask;
            output[x][y][z] = value;
        }
        return output;
    }

    public static short[][][] readPaletteValues1_16(int bitsPerEntry, int dimensionSize, long[] encodedValues) {
        short[][][] output = new short[dimensionSize][dimensionSize][dimensionSize];
        int valuesPerPalette = dimensionSize * dimensionSize * dimensionSize;
        int dimensionBitMask = dimensionSize - 1;
        int zDimensionBitShift = dimensionSize >> 2;
        int yDimensionBitShift = zDimensionBitShift + zDimensionBitShift;
        long maxEntryValue = (1L << bitsPerEntry) - 1L;
        char valuesPerLong = (char)(64 / bitsPerEntry);
        int magicIndex = 3 * (valuesPerLong - '\u0001');
        long divideMul = Integer.toUnsignedLong(MAGIC[magicIndex]);
        long divideAdd = Integer.toUnsignedLong(MAGIC[magicIndex + 1]);
        int divideShift = MAGIC[magicIndex + 2];
        for (int i = 0; i < valuesPerPalette; ++i) {
            int cellIndex = (int)((long)i * divideMul + divideAdd >> 32 >> divideShift);
            int bitIndex = (i - cellIndex * valuesPerLong) * bitsPerEntry;
            short value = (short)(encodedValues[cellIndex] >>> bitIndex & maxEntryValue);
            int x = i & dimensionBitMask;
            int z = i >> zDimensionBitShift & dimensionBitMask;
            int y = i >> yDimensionBitShift & dimensionBitMask;
            output[x][y][z] = value;
        }
        return output;
    }
}

