/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaTrimPatternResolver
implements Resolver<String, ChunkerTrimPattern> {
    private final InvertibleMap<ChunkerTrimPattern, String> mapping = InvertibleMap.enumKeys(ChunkerTrimPattern.class);

    public JavaTrimPatternResolver(Version version) {
        if (version.isGreaterThanOrEqual(1, 19, 4)) {
            this.mapping.put(ChunkerTrimPattern.COAST, "minecraft:coast");
            this.mapping.put(ChunkerTrimPattern.DUNE, "minecraft:dune");
            this.mapping.put(ChunkerTrimPattern.EYE, "minecraft:eye");
            this.mapping.put(ChunkerTrimPattern.RIB, "minecraft:rib");
            this.mapping.put(ChunkerTrimPattern.SENTRY, "minecraft:sentry");
            this.mapping.put(ChunkerTrimPattern.SNOUT, "minecraft:snout");
            this.mapping.put(ChunkerTrimPattern.SPIRE, "minecraft:spire");
            this.mapping.put(ChunkerTrimPattern.TIDE, "minecraft:tide");
            this.mapping.put(ChunkerTrimPattern.VEX, "minecraft:vex");
            this.mapping.put(ChunkerTrimPattern.WARD, "minecraft:ward");
            this.mapping.put(ChunkerTrimPattern.WILD, "minecraft:wild");
        }
        if (version.isGreaterThanOrEqual(1, 20, 0)) {
            this.mapping.put(ChunkerTrimPattern.HOST, "minecraft:host");
            this.mapping.put(ChunkerTrimPattern.RAISER, "minecraft:raiser");
            this.mapping.put(ChunkerTrimPattern.SHAPER, "minecraft:shaper");
            this.mapping.put(ChunkerTrimPattern.SILENCE, "minecraft:silence");
            this.mapping.put(ChunkerTrimPattern.WAYFINDER, "minecraft:wayfinder");
        }
        if (version.isGreaterThanOrEqual(1, 20, 5)) {
            this.mapping.put(ChunkerTrimPattern.BOLT, "minecraft:bolt");
            this.mapping.put(ChunkerTrimPattern.FLOW, "minecraft:flow");
        }
    }

    @Override
    public Optional<String> from(ChunkerTrimPattern input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerTrimPattern> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        }
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

