/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaPotionTypeResolver
implements Resolver<String, ChunkerPotionType> {
    private final InvertibleMap<ChunkerPotionType, String> mapping = InvertibleMap.enumKeys(ChunkerPotionType.class);

    public JavaPotionTypeResolver(Version javaVersion) {
        this.mapping.put(ChunkerPotionType.WATER, "minecraft:water");
        this.mapping.put(ChunkerPotionType.MUNDANE, "minecraft:mundane");
        this.mapping.put(ChunkerPotionType.THICK, "minecraft:thick");
        this.mapping.put(ChunkerPotionType.AWKWARD, "minecraft:awkward");
        this.mapping.put(ChunkerPotionType.NIGHT_VISION, "minecraft:night_vision");
        this.mapping.put(ChunkerPotionType.LONG_NIGHT_VISION, "minecraft:long_night_vision");
        this.mapping.put(ChunkerPotionType.INVISIBILITY, "minecraft:invisibility");
        this.mapping.put(ChunkerPotionType.LONG_INVISIBILITY, "minecraft:long_invisibility");
        this.mapping.put(ChunkerPotionType.LEAPING, "minecraft:leaping");
        this.mapping.put(ChunkerPotionType.LONG_LEAPING, "minecraft:long_leaping");
        this.mapping.put(ChunkerPotionType.STRONG_LEAPING, "minecraft:strong_leaping");
        this.mapping.put(ChunkerPotionType.FIRE_RESISTANCE, "minecraft:fire_resistance");
        this.mapping.put(ChunkerPotionType.LONG_FIRE_RESISTANCE, "minecraft:long_fire_resistance");
        this.mapping.put(ChunkerPotionType.SWIFTNESS, "minecraft:swiftness");
        this.mapping.put(ChunkerPotionType.LONG_SWIFTNESS, "minecraft:long_swiftness");
        this.mapping.put(ChunkerPotionType.STRONG_SWIFTNESS, "minecraft:strong_swiftness");
        this.mapping.put(ChunkerPotionType.SLOWNESS, "minecraft:slowness");
        this.mapping.put(ChunkerPotionType.LONG_SLOWNESS, "minecraft:long_slowness");
        this.mapping.put(ChunkerPotionType.STRONG_SLOWNESS, "minecraft:strong_slowness");
        this.mapping.put(ChunkerPotionType.WATER_BREATHING, "minecraft:water_breathing");
        this.mapping.put(ChunkerPotionType.LONG_WATER_BREATHING, "minecraft:long_water_breathing");
        this.mapping.put(ChunkerPotionType.HEALING, "minecraft:healing");
        this.mapping.put(ChunkerPotionType.STRONG_HEALING, "minecraft:strong_healing");
        this.mapping.put(ChunkerPotionType.HARMING, "minecraft:harming");
        this.mapping.put(ChunkerPotionType.STRONG_HARMING, "minecraft:strong_harming");
        this.mapping.put(ChunkerPotionType.POISON, "minecraft:poison");
        this.mapping.put(ChunkerPotionType.LONG_POISON, "minecraft:long_poison");
        this.mapping.put(ChunkerPotionType.STRONG_POISON, "minecraft:strong_poison");
        this.mapping.put(ChunkerPotionType.REGENERATION, "minecraft:regeneration");
        this.mapping.put(ChunkerPotionType.LONG_REGENERATION, "minecraft:long_regeneration");
        this.mapping.put(ChunkerPotionType.STRONG_REGENERATION, "minecraft:strong_regeneration");
        this.mapping.put(ChunkerPotionType.STRENGTH, "minecraft:strength");
        this.mapping.put(ChunkerPotionType.LONG_STRENGTH, "minecraft:long_strength");
        this.mapping.put(ChunkerPotionType.STRONG_STRENGTH, "minecraft:strong_strength");
        this.mapping.put(ChunkerPotionType.WEAKNESS, "minecraft:weakness");
        this.mapping.put(ChunkerPotionType.LONG_WEAKNESS, "minecraft:long_weakness");
        this.mapping.put(ChunkerPotionType.LUCK, "minecraft:luck");
        this.mapping.put(ChunkerPotionType.TURTLE_MASTER, "minecraft:turtle_master");
        this.mapping.put(ChunkerPotionType.LONG_TURTLE_MASTER, "minecraft:long_turtle_master");
        this.mapping.put(ChunkerPotionType.STRONG_TURTLE_MASTER, "minecraft:strong_turtle_master");
        this.mapping.put(ChunkerPotionType.SLOW_FALLING, "minecraft:slow_falling");
        this.mapping.put(ChunkerPotionType.LONG_SLOW_FALLING, "minecraft:long_slow_falling");
        if (javaVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerPotionType.WIND_CHARGED, "minecraft:wind_charged");
            this.mapping.put(ChunkerPotionType.WEAVING, "minecraft:weaving");
            this.mapping.put(ChunkerPotionType.OOZING, "minecraft:oozing");
            this.mapping.put(ChunkerPotionType.INFESTED, "minecraft:infested");
        }
    }

    @Override
    public Optional<String> from(ChunkerPotionType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerPotionType> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        }
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

