/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.resolver.itemstack.ItemStackResolver;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerVanillaItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemDisplay;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkExplosion;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkShape;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworks;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.horn.ChunkerHornInstrument;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.stew.ChunkerStewEffect;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrim;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.ShortTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import com.hivemc.chunker.resolver.property.PropertyHandler;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaItemStackResolver
extends ItemStackResolver<JavaResolvers, CompoundTag> {
    public JavaItemStackResolver(JavaResolvers resolvers) {
        super(resolvers);
    }

    @Override
    protected void registerHandlers(final JavaResolvers resolvers) {
        this.registerHandler(ChunkerItemProperty.AMOUNT, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return Optional.of(Integer.valueOf(value.getByte("Count", (byte)1)));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer count) {
                value.put("Count", count.byteValue());
            }
        });
        this.registerHandler(ChunkerItemProperty.DURABILITY, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("Damage", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer damage) {
                value.getOrCreateCompound("tag").put("Damage", damage);
            }
        });
        this.registerHandler(ChunkerItemProperty.DISPLAY, new PropertyHandler<CompoundTag, ChunkerItemDisplay>(){

            @Override
            public Optional<ChunkerItemDisplay> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                String name = null;
                List lore = null;
                Color color = null;
                CompoundTag display = tag.getCompound("display");
                if (display != null) {
                    name = display.getString("Name", null);
                    List loreString = display.getListValues("Lore", StringTag.class, null);
                    if (loreString != null) {
                        lore = loreString.stream().map(JsonTextUtil::fromJSON).collect(Collectors.toList());
                    }
                    if (display.contains("color")) {
                        color = new Color(display.getInt("color"));
                    }
                }
                return name != null || lore != null || color != null ? Optional.of(new ChunkerItemDisplay(name != null ? JsonTextUtil.fromJSON(name) : null, lore, color)) : Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerItemDisplay chunkerItemDisplay) {
                CompoundTag display = value.getOrCreateCompound("tag").getOrCreateCompound("display");
                if (chunkerItemDisplay.displayName() != null) {
                    display.put("Name", JsonTextUtil.toJSON(chunkerItemDisplay.displayName()));
                }
                if (chunkerItemDisplay.lore() != null) {
                    display.put("Lore", ListTag.fromValues(TagType.STRING, Lists.transform(chunkerItemDisplay.lore(), JsonTextUtil::toJSON)));
                }
                if (chunkerItemDisplay.color() != null) {
                    display.put("color", chunkerItemDisplay.color().getRGB());
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_PLACE_ON, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                List names = tag.getListValues("CanPlaceOn", StringTag.class, null);
                if (names == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(names.size());
                for (String name : names) {
                    ChunkerBlockIdentifier identifier = resolvers.readBlockIdentifier(new Identifier(name)).copyWithout(VanillaBlockStates.WATERLOGGED);
                    if (identifier.isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ArrayList<String> identifiers = new ArrayList<String>(chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    identifiers.add(identifier.get().getIdentifier());
                }
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("CanPlaceOn", ListTag.fromValues(TagType.STRING, identifiers));
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_DESTROY, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                List names = tag.getListValues("CanDestroy", StringTag.class, null);
                if (names == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(names.size());
                for (String name : names) {
                    ChunkerBlockIdentifier identifier = resolvers.readBlockIdentifier(new Identifier(name)).copyWithout(VanillaBlockStates.WATERLOGGED);
                    if (identifier.isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ArrayList<String> identifiers = new ArrayList<String>(chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    identifiers.add(identifier.get().getIdentifier());
                }
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("CanDestroy", ListTag.fromValues(TagType.STRING, identifiers));
            }
        });
        this.registerHandler(ChunkerItemProperty.REPAIR_COST, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("RepairCost", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer repairCost) {
                value.getOrCreateCompound("tag").put("RepairCost", repairCost);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.ENCHANTMENTS, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, Map<ChunkerEnchantmentType, Integer>>(){

            @Override
            public Optional<Map<ChunkerEnchantmentType, Integer>> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                String name = tag.contains("StoredEnchantments") ? "StoredEnchantments" : "Enchantments";
                ListTag enchantmentTags = tag.getList(name, CompoundTag.class, null);
                if (enchantmentTags == null) {
                    return Optional.empty();
                }
                EnumMap<ChunkerEnchantmentType, Integer> enchantments = new EnumMap<ChunkerEnchantmentType, Integer>(ChunkerEnchantmentType.class);
                for (CompoundTag enchantment : enchantmentTags) {
                    String id = enchantment.getString("id", null);
                    if (id == null) continue;
                    Optional<ChunkerEnchantmentType> enchantmentType = resolvers.enchantmentResolver().to(id);
                    if (enchantmentType.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, id);
                        continue;
                    }
                    short level = enchantment.getShort("lvl", (short)1);
                    enchantments.put(enchantmentType.get(), Integer.valueOf(level));
                }
                return Optional.of(enchantments);
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull Map<ChunkerEnchantmentType, Integer> value) {
                ListTag enchantments = new ListTag(TagType.COMPOUND, value.size());
                for (Map.Entry<ChunkerEnchantmentType, Integer> enchantment : value.entrySet()) {
                    Optional<String> id = resolvers.enchantmentResolver().from(enchantment.getKey());
                    if (id.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, String.valueOf((Object)enchantment.getKey()));
                        continue;
                    }
                    CompoundTag enchantmentTag = new CompoundTag(2);
                    enchantmentTag.put("id", id.get());
                    enchantmentTag.put("lvl", enchantment.getValue().shortValue());
                    enchantments.add(enchantmentTag);
                }
                String name = state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.ENCHANTED_BOOK ? "StoredEnchantments" : "Enchantments";
                state.value().getOrCreateCompound("tag").put(name, enchantments);
            }
        });
        this.registerHandler(ChunkerItemProperty.MAP_INDEX, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                Optional<Integer> id = tag.getOptionalValue("map", Integer.class);
                if (id.isPresent() && resolvers.converter().level().isPresent()) {
                    ChunkerLevel level = resolvers.converter().level().get();
                    return level.findMapIndexByOriginalID(id.get().intValue());
                }
                return Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer index) {
                if (resolvers.converter().level().isPresent()) {
                    Optional<ChunkerMap> chunkerMap = resolvers.converter().level().get().getMapByIndex(index);
                    chunkerMap.ifPresent(map -> value.getOrCreateCompound("tag").put("map", (int)map.getId()));
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.SPAWN_EGG_MOB, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, ChunkerEntityType>(){

            @Override
            public Optional<ChunkerEntityType> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag entityTag = tag.getCompound("EntityTag");
                if (entityTag == null) {
                    return Optional.empty();
                }
                return entityTag.getOptionalValue("id", String.class).flatMap(identifier -> {
                    Optional<ChunkerEntityType> type = resolvers.entityTypeResolver().to((String)identifier);
                    if (type.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, (String)identifier);
                        if (((ChunkerItemStack)state.key()).getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                            state.key(null);
                        }
                    }
                    return type;
                });
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull ChunkerEntityType entityType) {
                Optional<String> type = resolvers.entityTypeResolver().from(entityType);
                if (type.isPresent()) {
                    CompoundTag entityTag = state.value().getOrCreateCompound("tag").getOrCreateCompound("EntityTag");
                    entityTag.put("id", type.get());
                } else {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, String.valueOf(entityType));
                    if (state.key().getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                        state.value(null);
                    }
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.BOOK_TITLE, new PropertyHandler<CompoundTag, String>(){

            @Override
            public Optional<String> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("title", String.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull String title) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("title", title);
            }
        });
        this.registerHandler(ChunkerItemProperty.BOOK_AUTHOR, new PropertyHandler<CompoundTag, String>(){

            @Override
            public Optional<String> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("author", String.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull String author) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("author", author);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BOOK_PAGES, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, List<JsonElement>>(){

            @Override
            public Optional<List<JsonElement>> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.right().getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                List pages = tag.getListValues("pages", StringTag.class, null);
                if (pages == null) {
                    return Optional.empty();
                }
                ArrayList<JsonElement> pagesJSON = new ArrayList<JsonElement>(pages.size());
                for (String page : pages) {
                    if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK) {
                        pagesJSON.add(JsonTextUtil.fromText(page));
                        continue;
                    }
                    pagesJSON.add(JsonTextUtil.fromJSON(page));
                }
                return Optional.of(pagesJSON);
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull List<JsonElement> pagesJSON) {
                CompoundTag tag = state.right().getOrCreateCompound("tag");
                ListTag<StringTag, String> pages = new ListTag<StringTag, String>(TagType.STRING, pagesJSON.size());
                for (JsonElement pageJSON : pagesJSON) {
                    if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITABLE_BOOK) {
                        pages.add(new StringTag(JsonTextUtil.toLegacy(pageJSON, false)));
                        continue;
                    }
                    pages.add(new StringTag(JsonTextUtil.toJSON(pageJSON)));
                }
                tag.put("pages", pages);
            }

            @Override
            @Nullable
            public List<JsonElement> getDefaultValue(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.WRITTEN_BOOK) {
                    return Collections.emptyList();
                }
                return (List)PropertyHandler.super.getDefaultValue(state);
            }
        });
        this.registerHandler(ChunkerItemProperty.HORN_INSTRUMENT, new PropertyHandler<CompoundTag, ChunkerHornInstrument>(){

            @Override
            public Optional<ChunkerHornInstrument> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("instrument", String.class)).map(resolvers::readHornInstrument);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerHornInstrument hornInstrument) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("instrument", resolvers.writeHornInstrument(hornInstrument));
            }
        });
        this.registerHandler(ChunkerItemProperty.POTION, new PropertyHandler<CompoundTag, ChunkerPotionType>(){

            @Override
            public Optional<ChunkerPotionType> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("Potion", String.class)).map(resolvers::readPotionType);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerPotionType potionType) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("Potion", resolvers.writePotionType(potionType));
            }
        });
        this.registerHandler(ChunkerItemProperty.TRIM, new PropertyHandler<CompoundTag, ChunkerTrim>(){

            @Override
            public Optional<ChunkerTrim> read(@NotNull CompoundTag value) {
                Optional trim = value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptional("Trim", CompoundTag.class));
                if (trim.isEmpty()) {
                    return Optional.empty();
                }
                Optional trimPattern = ((CompoundTag)trim.get()).getOptionalValue("pattern", String.class).flatMap(identifier -> {
                    Optional<ChunkerTrimPattern> result = resolvers.trimPatternResolver().to((String)identifier);
                    if (result.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_PATTERN, (String)identifier);
                    }
                    return result;
                });
                if (trimPattern.isEmpty()) {
                    return Optional.empty();
                }
                Optional trimMaterial = ((CompoundTag)trim.get()).getOptionalValue("material", String.class).flatMap(identifier -> {
                    Optional<ChunkerTrimMaterial> result = resolvers.trimMaterialResolver().to((String)identifier);
                    if (result.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_MATERIAL, (String)identifier);
                    }
                    return result;
                });
                if (trimMaterial.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new ChunkerTrim((ChunkerTrimMaterial)((Object)trimMaterial.get()), (ChunkerTrimPattern)((Object)trimPattern.get())));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerTrim chunkerTrim) {
                Optional<String> trimPattern = resolvers.trimPatternResolver().from(chunkerTrim.getPattern());
                if (trimPattern.isEmpty()) {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_PATTERN, String.valueOf((Object)chunkerTrim.getPattern()));
                    return;
                }
                Optional<String> trimMaterial = resolvers.trimMaterialResolver().from(chunkerTrim.getMaterial());
                if (trimMaterial.isEmpty()) {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.TRIM_MATERIAL, String.valueOf((Object)chunkerTrim.getMaterial()));
                    return;
                }
                CompoundTag tag = value.getOrCreateCompound("tag").getOrCreateCompound("Trim");
                tag.put("material", trimMaterial.get());
                tag.put("pattern", trimPattern.get());
            }
        });
        this.registerHandler(ChunkerItemProperty.STEW_EFFECT, new PropertyHandler<CompoundTag, ChunkerStewEffect>(){

            @Override
            public Optional<ChunkerStewEffect> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("tag", CompoundTag.class).flatMap(tag -> Optional.ofNullable(tag.getList("effects", CompoundTag.class, null)));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                ListTag effectTags = (ListTag)component.get();
                EnumMap<ChunkerEffectType, Integer> effectDurationMap = new EnumMap<ChunkerEffectType, Integer>(ChunkerEffectType.class);
                for (CompoundTag effectTag : effectTags) {
                    ChunkerEffectType effectType = resolvers.readEffect(effectTag.getString("id", null));
                    if (effectType == ChunkerEffectType.EMPTY) continue;
                    int duration = effectTag.getInt("duration", 160);
                    effectDurationMap.put(effectType, duration);
                }
                return Optional.of(new ChunkerStewEffect(effectDurationMap));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerStewEffect chunkerStewEffect) {
                if (chunkerStewEffect.getEffects().isEmpty()) {
                    return;
                }
                ListTag effectTags = new ListTag(TagType.COMPOUND, chunkerStewEffect.getEffects().size());
                for (Map.Entry<ChunkerEffectType, Integer> effect : chunkerStewEffect.getEffects().entrySet()) {
                    String id = resolvers.writeEffect(effect.getKey());
                    CompoundTag effectTag = new CompoundTag(2);
                    effectTag.put("duration", effect.getValue());
                    effectTag.put("id", id);
                    effectTags.add(effectTag);
                }
                value.getOrCreateCompound("tag").put("effects", effectTags);
            }
        });
        this.registerHandler(ChunkerItemProperty.FIREWORKS, new PropertyHandler<CompoundTag, ChunkerFireworks>(){

            @Override
            public Optional<ChunkerFireworks> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptional("Fireworks", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                byte duration = ((CompoundTag)component.get()).getByte("Flight", (byte)1);
                List<ChunkerFireworkExplosion> explosions = Collections.emptyList();
                ListTag explosionsTag = ((CompoundTag)component.get()).getList("Explosions", CompoundTag.class, null);
                if (explosionsTag != null) {
                    explosions = new ArrayList<ChunkerFireworkExplosion>(explosionsTag.size());
                    for (CompoundTag explosionTag : explosionsTag) {
                        ChunkerFireworkShape shape = explosionTag.getOptionalValue("Type", Byte.class).map(Byte::intValue).flatMap(ChunkerFireworkShape::getByID).orElse(ChunkerFireworkShape.SMALL_BALL);
                        int[] colorsRGB = explosionTag.getIntArray("Colors", null);
                        List<Color> colors = colorsRGB == null ? Collections.emptyList() : IntStream.of(colorsRGB).mapToObj(Color::new).toList();
                        int[] fadeColorsRGB = explosionTag.getIntArray("FadeColors", null);
                        List<Color> fadeColors = fadeColorsRGB == null ? Collections.emptyList() : IntStream.of(fadeColorsRGB).mapToObj(Color::new).toList();
                        boolean trail = explosionTag.getByte("Trail", (byte)0) == 1;
                        boolean twinkle = explosionTag.getByte("Flicker", (byte)0) == 1;
                        explosions.add(new ChunkerFireworkExplosion(shape, colors, fadeColors, trail, twinkle));
                    }
                }
                return Optional.of(new ChunkerFireworks(duration, explosions));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerFireworks chunkerFireworks) {
                if (chunkerFireworks.getExplosions().isEmpty() && chunkerFireworks.getFlightDuration() == 0) {
                    return;
                }
                CompoundTag tag = value.getOrCreateCompound("tag").getOrCreateCompound("Fireworks");
                tag.put("Flight", chunkerFireworks.getFlightDuration());
                if (!chunkerFireworks.getExplosions().isEmpty()) {
                    ListTag explosions = new ListTag(TagType.COMPOUND, chunkerFireworks.getExplosions().size());
                    for (ChunkerFireworkExplosion chunkerFireworkExplosion : chunkerFireworks.getExplosions()) {
                        CompoundTag explosion = new CompoundTag(5);
                        explosion.put("Type", (byte)chunkerFireworkExplosion.getShape().getID());
                        explosion.put("Colors", chunkerFireworkExplosion.getColors().stream().mapToInt(Color::getRGB).toArray());
                        explosion.put("FadeColors", chunkerFireworkExplosion.getFadeColors().stream().mapToInt(Color::getRGB).toArray());
                        explosion.put("Trail", chunkerFireworkExplosion.isTrail() ? (byte)1 : 0);
                        explosion.put("Flicker", chunkerFireworkExplosion.isTwinkle() ? (byte)1 : 0);
                        explosions.add(explosion);
                    }
                    tag.put("Explosions", explosions);
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.BUNDLE_CONTENTS, new PropertyHandler<CompoundTag, List<ChunkerItemStack>>(){

            @Override
            public Optional<List<ChunkerItemStack>> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalList("Items", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                ListTag items = (ListTag)component.get();
                ArrayList<ChunkerItemStack> bundleContents = new ArrayList<ChunkerItemStack>(items.size());
                for (CompoundTag itemTag : items) {
                    ChunkerItemStack item = resolvers.readItem(itemTag);
                    if (item.getIdentifier().isAir()) continue;
                    bundleContents.add(item);
                }
                return Optional.of(bundleContents);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerItemStack> bundleContents) {
                ListTag items = new ListTag(TagType.COMPOUND, bundleContents.size());
                for (ChunkerItemStack item : bundleContents) {
                    Optional<CompoundTag> itemTag;
                    if (item.getIdentifier().isAir() || (itemTag = resolvers.writeItem(item)).isEmpty()) continue;
                    items.add(itemTag.get());
                }
                value.getOrCreateCompound("tag").put("Items", items);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.ENTITY, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, Entity>(){

            @Override
            public Optional<Entity> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                CompoundTag entityTag = tag.getCompound("EntityTag");
                Optional<Entity> generated = Optional.empty();
                if (entityTag != null) {
                    if (entityTag.contains("id")) {
                        generated = resolvers.entityResolver().to(entityTag);
                    } else if (state.key().getIdentifier().getItemStackType() == ChunkerVanillaItemType.PAINTING) {
                        generated = resolvers.entityResolver().to((Class<Entity>)PaintingEntity.class, entityTag);
                    }
                }
                return generated;
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull Entity value) {
                Optional<CompoundTag> entityTag = resolvers.entityResolver().from(value);
                if (entityTag.isPresent()) {
                    CompoundTag tag = entityTag.get();
                    tag.remove("block_pos");
                    tag.remove("TileX");
                    tag.remove("TileY");
                    tag.remove("TileZ");
                    tag.remove("Pos");
                    tag.remove("Motion");
                    tag.remove("Rotation");
                    tag.remove("Rot");
                    tag.remove("facing");
                    tag.remove("Facing");
                    if (value instanceof PaintingEntity) {
                        tag.remove("id");
                    }
                    state.value().getOrCreateCompound("tag").put("EntityTag", tag);
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BLOCK_ENTITY, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, BlockEntity>(){

            @Override
            public Optional<BlockEntity> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                CompoundTag tag = state.value().getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                Optional<Class<BlockEntity>> blockEntityClass = resolvers.blockEntityResolver().getBlockEntityClass(state.key().getIdentifier().getItemStackType());
                if (blockEntityClass.isEmpty()) {
                    return Optional.empty();
                }
                CompoundTag blockEntityTag = tag.getCompound("BlockEntityTag");
                Optional<Object> generated = Optional.empty();
                if (blockEntityTag != null) {
                    generated = resolvers.blockEntityResolver().to(blockEntityClass.get(), blockEntityTag);
                }
                generated = resolvers.blockEntityResolver().generateFromItemNBT(blockEntityClass.get(), state.key(), generated.orElse(null), state.value());
                return generated.map(blockEntity -> resolvers.blockEntityResolver().updateBeforeProcess((CompoundTag)state.value(), (ChunkerItemStack)state.key(), blockEntity));
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull BlockEntity value) {
                Optional<CompoundTag> blockEntityTag;
                value = resolvers.blockEntityResolver().updateBeforeWrite(state.value(), state.key(), value);
                boolean writeBlockEntityData = resolvers.blockEntityResolver().writeToItemNBT(state.key(), value, state.value());
                if (writeBlockEntityData && (blockEntityTag = resolvers.blockEntityResolver().from(value)).isPresent()) {
                    CompoundTag tag = blockEntityTag.get();
                    tag.remove("x");
                    tag.remove("y");
                    tag.remove("z");
                    tag.remove("id");
                    tag.remove("Rotation");
                    tag.remove("Rot");
                    tag.remove("facing");
                    tag.remove("Facing");
                    state.value().getOrCreateCompound("tag").put("BlockEntityTag", tag);
                }
            }
        });
    }

    @Override
    protected Optional<ChunkerItemStack> createPropertyHolder(CompoundTag input) {
        OptionalInt damage;
        Object damageTag = input.get("Damage");
        if (damageTag instanceof IntTag) {
            IntTag intTag = (IntTag)damageTag;
            damage = OptionalInt.of(intTag.getValue());
        } else if (damageTag instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)damageTag;
            damage = OptionalInt.of(shortTag.getValue());
        } else {
            damage = OptionalInt.of(0);
        }
        Identifier identifier = Identifier.fromData(input.getString("id"), damage);
        return Optional.of(((JavaResolvers)this.resolvers).readItemIdentifier(identifier));
    }

    @Override
    protected Optional<CompoundTag> createOutput(ChunkerItemStack input) {
        CompoundTag output = new CompoundTag(2);
        Optional<Identifier> itemIdentifier = ((JavaResolvers)this.resolvers).chunkerItemIdentifierResolver().from(input);
        if (itemIdentifier.isPresent()) {
            output.put("id", itemIdentifier.get().getIdentifier());
            if (itemIdentifier.get().getDataValue().isPresent()) {
                output.put("Damage", itemIdentifier.get().getDataValue().getAsInt());
            }
            return Optional.of(output);
        }
        ChunkerItemStackIdentifier chunkerItemStackIdentifier = input.getIdentifier();
        if (chunkerItemStackIdentifier instanceof ChunkerBlockIdentifier) {
            ChunkerBlockIdentifier chunkerBlockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier;
            Optional<Identifier> blockIdentifier = ((JavaResolvers)this.resolvers).writeBlockIdentifier(chunkerBlockIdentifier, false);
            if (blockIdentifier.isEmpty()) {
                return Optional.empty();
            }
            output.put("id", blockIdentifier.get().getIdentifier());
            return Optional.of(output);
        }
        return Optional.empty();
    }
}

