/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaEnchantmentResolver
implements Resolver<String, ChunkerEnchantmentType> {
    private final InvertibleMap<ChunkerEnchantmentType, String> mapping = InvertibleMap.enumKeys(ChunkerEnchantmentType.class);

    public JavaEnchantmentResolver(Version javaVersion) {
        this.mapping.put(ChunkerEnchantmentType.ALL_DAMAGE_PROTECTION, "minecraft:protection");
        this.mapping.put(ChunkerEnchantmentType.FIRE_PROTECTION, "minecraft:fire_protection");
        this.mapping.put(ChunkerEnchantmentType.FALL_PROTECTION, "minecraft:feather_falling");
        this.mapping.put(ChunkerEnchantmentType.BLAST_PROTECTION, "minecraft:blast_protection");
        this.mapping.put(ChunkerEnchantmentType.PROJECTILE_PROTECTION, "minecraft:projectile_protection");
        this.mapping.put(ChunkerEnchantmentType.RESPIRATION, "minecraft:respiration");
        this.mapping.put(ChunkerEnchantmentType.AQUA_AFFINITY, "minecraft:aqua_affinity");
        this.mapping.put(ChunkerEnchantmentType.THORNS, "minecraft:thorns");
        this.mapping.put(ChunkerEnchantmentType.DEPTH_STRIDER, "minecraft:depth_strider");
        this.mapping.put(ChunkerEnchantmentType.SHARPNESS, "minecraft:sharpness");
        this.mapping.put(ChunkerEnchantmentType.SMITE, "minecraft:smite");
        this.mapping.put(ChunkerEnchantmentType.BANE_OF_ARTHROPODS, "minecraft:bane_of_arthropods");
        this.mapping.put(ChunkerEnchantmentType.KNOCKBACK, "minecraft:knockback");
        this.mapping.put(ChunkerEnchantmentType.FIRE_ASPECT, "minecraft:fire_aspect");
        this.mapping.put(ChunkerEnchantmentType.MOB_LOOTING, "minecraft:looting");
        this.mapping.put(ChunkerEnchantmentType.SWEEPING_EDGE, "minecraft:sweeping");
        this.mapping.put(ChunkerEnchantmentType.BLOCK_EFFICIENCY, "minecraft:efficiency");
        this.mapping.put(ChunkerEnchantmentType.SILK_TOUCH, "minecraft:silk_touch");
        this.mapping.put(ChunkerEnchantmentType.UNBREAKING, "minecraft:unbreaking");
        this.mapping.put(ChunkerEnchantmentType.BLOCK_FORTUNE, "minecraft:fortune");
        this.mapping.put(ChunkerEnchantmentType.POWER_ARROWS, "minecraft:power");
        this.mapping.put(ChunkerEnchantmentType.PUNCH_ARROWS, "minecraft:punch");
        this.mapping.put(ChunkerEnchantmentType.FLAMING_ARROWS, "minecraft:flame");
        this.mapping.put(ChunkerEnchantmentType.INFINITY_ARROWS, "minecraft:infinity");
        this.mapping.put(ChunkerEnchantmentType.FISHING_LUCK, "minecraft:luck_of_the_sea");
        this.mapping.put(ChunkerEnchantmentType.FISHING_SPEED, "minecraft:lure");
        if (javaVersion.isGreaterThanOrEqual(1, 9, 0)) {
            this.mapping.put(ChunkerEnchantmentType.FROST_WALKER, "minecraft:frost_walker");
            this.mapping.put(ChunkerEnchantmentType.MENDING, "minecraft:mending");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 11, 0)) {
            this.mapping.put(ChunkerEnchantmentType.BINDING_CURSE, "minecraft:binding_curse");
            this.mapping.put(ChunkerEnchantmentType.VANISHING_CURSE, "minecraft:vanishing_curse");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 13, 0)) {
            this.mapping.put(ChunkerEnchantmentType.IMPALING, "minecraft:impaling");
            this.mapping.put(ChunkerEnchantmentType.RIPTIDE, "minecraft:riptide");
            this.mapping.put(ChunkerEnchantmentType.LOYALTY, "minecraft:loyalty");
            this.mapping.put(ChunkerEnchantmentType.CHANNELING, "minecraft:channeling");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 14, 0)) {
            this.mapping.put(ChunkerEnchantmentType.MULTISHOT, "minecraft:multishot");
            this.mapping.put(ChunkerEnchantmentType.PIERCING, "minecraft:piercing");
            this.mapping.put(ChunkerEnchantmentType.QUICK_CHARGE, "minecraft:quick_charge");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerEnchantmentType.SOUL_SPEED, "minecraft:soul_speed");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerEnchantmentType.SWIFT_SNEAK, "minecraft:swift_sneak");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 20, 5)) {
            this.mapping.put(ChunkerEnchantmentType.SWEEPING_EDGE, "minecraft:sweeping_edge");
        }
        if (javaVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerEnchantmentType.WIND_BURST, "minecraft:wind_burst");
            this.mapping.put(ChunkerEnchantmentType.DENSITY, "minecraft:density");
            this.mapping.put(ChunkerEnchantmentType.BREACH, "minecraft:breach");
        }
    }

    @Override
    public Optional<String> from(ChunkerEnchantmentType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerEnchantmentType> to(String input) {
        if (!((String)input).contains(":")) {
            input = "minecraft:" + (String)input;
        }
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

