/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.banner.ChunkerBannerPattern;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class JavaBannerPatternShortNameResolver
implements Resolver<String, ChunkerBannerPattern> {
    private final InvertibleMap<ChunkerBannerPattern, String> mapping = InvertibleMap.enumKeys(ChunkerBannerPattern.class);

    public JavaBannerPatternShortNameResolver(Version version) {
        this.mapping.put(ChunkerBannerPattern.BASE, "b");
        this.mapping.put(ChunkerBannerPattern.SQUARE_BOTTOM_LEFT, "bl");
        this.mapping.put(ChunkerBannerPattern.SQUARE_BOTTOM_RIGHT, "br");
        this.mapping.put(ChunkerBannerPattern.SQUARE_TOP_LEFT, "tl");
        this.mapping.put(ChunkerBannerPattern.SQUARE_TOP_RIGHT, "tr");
        this.mapping.put(ChunkerBannerPattern.STRIPE_BOTTOM, "bs");
        this.mapping.put(ChunkerBannerPattern.STRIPE_TOP, "ts");
        this.mapping.put(ChunkerBannerPattern.STRIPE_LEFT, "ls");
        this.mapping.put(ChunkerBannerPattern.STRIPE_RIGHT, "rs");
        this.mapping.put(ChunkerBannerPattern.STRIPE_CENTER, "cs");
        this.mapping.put(ChunkerBannerPattern.STRIPE_MIDDLE, "ms");
        this.mapping.put(ChunkerBannerPattern.STRIPE_DOWNRIGHT, "drs");
        this.mapping.put(ChunkerBannerPattern.STRIPE_DOWNLEFT, "dls");
        this.mapping.put(ChunkerBannerPattern.STRIPE_SMALL, "ss");
        this.mapping.put(ChunkerBannerPattern.CROSS, "cr");
        this.mapping.put(ChunkerBannerPattern.STRAIGHT_CROSS, "sc");
        this.mapping.put(ChunkerBannerPattern.TRIANGLE_BOTTOM, "bt");
        this.mapping.put(ChunkerBannerPattern.TRIANGLE_TOP, "tt");
        this.mapping.put(ChunkerBannerPattern.TRIANGLES_BOTTOM, "bts");
        this.mapping.put(ChunkerBannerPattern.TRIANGLES_TOP, "tts");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_LEFT, "ld");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_RIGHT, "rd");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_LEFT_MIRROR, "lud");
        this.mapping.put(ChunkerBannerPattern.DIAGONAL_RIGHT_MIRROR, "rud");
        this.mapping.put(ChunkerBannerPattern.CIRCLE_MIDDLE, "mc");
        this.mapping.put(ChunkerBannerPattern.RHOMBUS_MIDDLE, "mr");
        this.mapping.put(ChunkerBannerPattern.HALF_VERTICAL, "vh");
        this.mapping.put(ChunkerBannerPattern.HALF_HORIZONTAL, "hh");
        this.mapping.put(ChunkerBannerPattern.HALF_VERTICAL_MIRROR, "vhr");
        this.mapping.put(ChunkerBannerPattern.HALF_HORIZONTAL_MIRROR, "hhb");
        this.mapping.put(ChunkerBannerPattern.BORDER, "bo");
        this.mapping.put(ChunkerBannerPattern.CURLY_BORDER, "cbo");
        this.mapping.put(ChunkerBannerPattern.GRADIENT, "gra");
        this.mapping.put(ChunkerBannerPattern.GRADIENT_UP, "gru");
        this.mapping.put(ChunkerBannerPattern.BRICKS, "bri");
        this.mapping.put(ChunkerBannerPattern.GLOBE, "glb");
        this.mapping.put(ChunkerBannerPattern.CREEPER, "cre");
        this.mapping.put(ChunkerBannerPattern.SKULL, "sku");
        this.mapping.put(ChunkerBannerPattern.FLOWER, "flo");
        this.mapping.put(ChunkerBannerPattern.MOJANG, "moj");
        this.mapping.put(ChunkerBannerPattern.PIGLIN, "pig");
    }

    @Override
    public Optional<String> from(ChunkerBannerPattern input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerBannerPattern> to(String input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

