/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.identifier;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.resolver.Resolver;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class JavaNBTBlockIdentifierResolver
implements Resolver<CompoundTag, Identifier> {
    protected final Version version;

    public JavaNBTBlockIdentifierResolver(Version version) {
        this.version = version;
    }

    @Override
    public Optional<Identifier> to(CompoundTag input) {
        Map<String, StateValue<?>> states;
        String identifier = input.getString("Name", null);
        if (identifier == null) {
            return Optional.empty();
        }
        CompoundTag statesTag = input.getCompound("Properties");
        if (statesTag == null) {
            states = Collections.emptyMap();
        } else {
            states = new Object2ObjectOpenHashMap(statesTag.size());
            for (Map.Entry<String, Tag<?>> tag : statesTag) {
                states.put(tag.getKey(), StateValue.fromNBT(tag.getValue()));
            }
        }
        return Optional.of(new Identifier(identifier, states));
    }

    @Override
    public Optional<CompoundTag> from(Identifier input) {
        CompoundTag output = new CompoundTag(2);
        output.put("Name", input.getIdentifier());
        if (!input.getStates().isEmpty()) {
            CompoundTag states = new CompoundTag(input.getStates().size());
            for (Map.Entry<String, StateValue<?>> entry : input.getStates().entrySet()) {
                states.put(entry.getKey(), entry.getValue().toNBT());
            }
            output.put("Properties", states);
        }
        return Optional.of(output);
    }
}

