/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.entity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.DoubleTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaEntityHandler
extends EntityHandler<JavaResolvers, CompoundTag, Entity> {
    public JavaEntityHandler() {
        super(null, Entity.class, () -> {
            throw new IllegalArgumentException("Unable to construct Entity, invalid type!");
        });
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull Entity entity) {
        List rotation;
        List motion;
        List position;
        if (resolvers.converter().shouldAllowNBTCopying()) {
            entity.setOriginalNBT(input);
        }
        if ((position = input.getListValues("Pos", DoubleTag.class, null)) != null && position.size() >= 3) {
            entity.setPositionX((Double)position.get(0));
            entity.setPositionY((Double)position.get(1));
            entity.setPositionZ((Double)position.get(2));
        }
        if ((motion = input.getListValues("Motion", DoubleTag.class, null)) != null && motion.size() >= 3) {
            entity.setMotionX((Double)motion.get(0));
            entity.setMotionY((Double)motion.get(1));
            entity.setMotionZ((Double)motion.get(2));
        }
        if ((rotation = input.getListValues("Rotation", FloatTag.class, null)) != null && rotation.size() >= 2) {
            entity.setYaw(((Float)rotation.get(0)).floatValue());
            entity.setPitch(((Float)rotation.get(1)).floatValue());
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull Entity entity) {
        if (resolvers.converter().shouldAllowNBTCopying() && entity.getOriginalNBT() != null) {
            for (Map.Entry<String, Tag<?>> namedPair : entity.getOriginalNBT()) {
                output.put(namedPair.getKey(), (Tag<?>)namedPair.getValue().clone());
            }
        }
        ListTag<DoubleTag, Double> pos = new ListTag<DoubleTag, Double>(TagType.DOUBLE, 3);
        pos.add(new DoubleTag(entity.getPositionX()));
        pos.add(new DoubleTag(entity.getPositionY()));
        pos.add(new DoubleTag(entity.getPositionZ()));
        output.put("Pos", pos);
        ListTag<DoubleTag, Double> motion = new ListTag<DoubleTag, Double>(TagType.DOUBLE, 3);
        motion.add(new DoubleTag(entity.getMotionX()));
        motion.add(new DoubleTag(entity.getMotionY()));
        motion.add(new DoubleTag(entity.getMotionZ()));
        output.put("Motion", motion);
        ListTag<FloatTag, Float> rotation = new ListTag<FloatTag, Float>(TagType.FLOAT, 2);
        rotation.add(new FloatTag(entity.getYaw()));
        rotation.add(new FloatTag(entity.getPitch()));
        output.put("Rotation", rotation);
    }
}

