/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaRandomizableContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.RandomizableContainerBlockEntity;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaLegacyRandomizableContainerBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, RandomizableContainerBlockEntity> {
    public static final Set<String> UNSUPPORTED_LOOT_TABLES = Set.of("minecraft:chests/monster_room", "minecraft:chests/village_two_room_house");
    private final boolean enableLootTables;

    public JavaLegacyRandomizableContainerBlockEntityHandler(boolean enabledLootTables) {
        super("RandomizableBlockEntity", RandomizableContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to construct RandomizableBlockEntity, invalid type!");
        });
        this.enableLootTables = enabledLootTables;
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull RandomizableContainerBlockEntity blockEntity) {
        String lootTable = input.getString("LootTable", null);
        if (lootTable != null && !lootTable.isEmpty() && this.enableLootTables) {
            blockEntity.setLootTable(this.applyVersionSpecificLootTableFixes(resolvers, lootTable, false));
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull RandomizableContainerBlockEntity blockEntity) {
        if (blockEntity.getLootTable() != null && !blockEntity.getLootTable().isEmpty() && !UNSUPPORTED_LOOT_TABLES.contains(blockEntity.getLootTable()) && this.enableLootTables) {
            output.put("LootTable", this.applyVersionSpecificLootTableFixes(resolvers, blockEntity.getLootTable(), true));
        }
    }

    public String applyVersionSpecificLootTableFixes(@NotNull JavaResolvers resolvers, String lootTable, boolean writing) {
        if (!writing) {
            return lootTable;
        }
        return JavaRandomizableContainerBlockEntityHandler.PRE_1_14_LOOT_TABLES.getOrDefault(lootTable, lootTable);
    }
}

