/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.FurnaceBlockEntity;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.nbt.tags.primitive.ShortTag;
import org.jetbrains.annotations.NotNull;

public class JavaLegacyFurnaceBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, FurnaceBlockEntity> {
    public JavaLegacyFurnaceBlockEntityHandler() {
        super("Furnace", FurnaceBlockEntity.class, FurnaceBlockEntity::new);
    }

    public static short getShortOrInt(@NotNull CompoundTag tag, @NotNull String key, short defaultValue) {
        Object value = tag.get(key);
        if (value instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)value;
            return shortTag.getValue();
        }
        if (value instanceof IntTag) {
            IntTag intTag = (IntTag)value;
            return (short)intTag.getValue();
        }
        if (value == null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(value.getClass().getName() + " is not of type ShortTag / IntTag");
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull FurnaceBlockEntity value) {
        value.setBurnTime(JavaLegacyFurnaceBlockEntityHandler.getShortOrInt(input, "BurnTime", (short)0));
        value.setCookTime(JavaLegacyFurnaceBlockEntityHandler.getShortOrInt(input, "CookTime", (short)0));
        value.setCookTimeTotal(JavaLegacyFurnaceBlockEntityHandler.getShortOrInt(input, "CookTimeTotal", (short)0));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull FurnaceBlockEntity value) {
        output.put("BurnTime", value.getBurnTime());
        output.put("CookTime", value.getCookTime());
        output.put("CookTimeTotal", value.getCookTimeTotal());
    }
}

