/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.legacy.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaLegacyBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, BlockEntity> {
    public JavaLegacyBlockEntityHandler() {
        super("minecraft:block_entity", BlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to construct BlockEntity, invalid type!");
        });
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull BlockEntity blockEntity) {
        if (resolvers.converter().shouldAllowNBTCopying()) {
            blockEntity.setOriginalNBT(input);
        }
        blockEntity.setX(input.getInt("x", 0));
        blockEntity.setY(input.getInt("y", 0));
        blockEntity.setZ(input.getInt("z", 0));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull BlockEntity blockEntity) {
        if (resolvers.converter().shouldAllowNBTCopying() && blockEntity.getOriginalNBT() != null) {
            for (Map.Entry<String, Tag<?>> namedPair : blockEntity.getOriginalNBT()) {
                output.put(namedPair.getKey(), (Tag<?>)namedPair.getValue().clone());
            }
        }
        output.put("x", blockEntity.getX());
        output.put("y", blockEntity.getY());
        output.put("z", blockEntity.getZ());
    }
}

