/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SkullBlockEntity;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.array.IntArrayTag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class JavaSkullBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, SkullBlockEntity> {
    public JavaSkullBlockEntityHandler() {
        super("minecraft:skull", SkullBlockEntity.class, SkullBlockEntity::new);
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull SkullBlockEntity value) {
        if (input.contains("ExtraType")) {
            value.setOwnerName(input.getString("ExtraType", null));
        }
        if (input.contains("Owner") || input.contains("SkullOwner")) {
            ListTag textures;
            CompoundTag properties;
            CompoundTag owner = input.getCompound(input.contains("Owner") ? "Owner" : "SkullOwner");
            Object idTag = Objects.requireNonNull(owner).get("Id");
            if (idTag != null) {
                IntArrayTag intArrayTag;
                int[] ints;
                if (idTag instanceof StringTag) {
                    StringTag stringTag = (StringTag)idTag;
                    value.setOwnerId(stringTag.getValue());
                } else if (idTag instanceof IntArrayTag && (ints = (intArrayTag = (IntArrayTag)idTag).getValue()) != null && ints.length == 4) {
                    value.setOwnerId(new UUID((long)ints[0] << 32 | (long)ints[1] & 0xFFFFFFFFL, (long)ints[2] << 32 | (long)ints[3] & 0xFFFFFFFFL).toString());
                }
            }
            if (owner.contains("Name")) {
                value.setOwnerName(owner.getString("Name", null));
            }
            if ((properties = owner.getCompound("Properties")) != null && (textures = properties.getList("textures", CompoundTag.class, null)) != null && textures.size() > 0) {
                CompoundTag texture = textures.get(0);
                value.setTexture(texture.getString("Value", null));
                value.setTextureSignature(texture.getString("Signature", null));
            }
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull SkullBlockEntity value) {
        if (value.getOwnerId() != null || value.getTexture() != null || value.getTextureSignature() != null || value.getOwnerName() != null && resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 12, 0)) {
            CompoundTag owner = new CompoundTag(3);
            if (value.getOwnerId() != null) {
                if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 16, 0)) {
                    UUID uuid = UUID.fromString(value.getOwnerId());
                    owner.put("Id", new IntArrayTag(new int[]{(int)(uuid.getMostSignificantBits() >> 32), (int)uuid.getMostSignificantBits(), (int)(uuid.getLeastSignificantBits() >> 32), (int)uuid.getLeastSignificantBits()}));
                } else {
                    owner.put("Id", value.getOwnerId());
                }
            }
            if (value.getOwnerName() != null && resolvers.dataVersion().getVersion().isGreaterThan(1, 12, 0)) {
                owner.put("Name", value.getOwnerName());
            }
            if (value.getTexture() != null || value.getTextureSignature() != null) {
                CompoundTag textureEntry = new CompoundTag(2);
                if (value.getTexture() != null) {
                    textureEntry.put("Value", value.getTexture());
                }
                if (value.getTextureSignature() != null) {
                    textureEntry.put("Signature", value.getTextureSignature());
                }
                ListTag textures = new ListTag(TagType.COMPOUND, List.of(textureEntry));
                owner.put("Properties", new CompoundTag(Map.of("textures", textures)));
            }
            output.put(resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 16, 0) ? "SkullOwner" : "Owner", owner);
        } else if (value.getOwnerName() != null) {
            output.put("ExtraType", value.getOwnerName());
        }
    }
}

