/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sign.SignBlockEntity;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.util.JsonTextUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JavaSignBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, SignBlockEntity> {
    public JavaSignBlockEntityHandler() {
        super("minecraft:sign", SignBlockEntity.class, SignBlockEntity::new);
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull SignBlockEntity value) {
        value.setWaxed(input.getByte("is_waxed", (byte)0) == 1);
        this.readSignFace(input.getCompound("front_text", input), value.getFront());
        CompoundTag backText = input.getCompound("back_text");
        if (backText != null) {
            this.readSignFace(backText, value.getBack());
        }
    }

    protected void readSignFace(@NotNull CompoundTag input, SignBlockEntity.SignFace face) {
        if (input.contains("messages")) {
            ListTag textLines = input.get("messages", ListTag.class);
            if (textLines != null) {
                ArrayList<JsonElement> lines = new ArrayList<JsonElement>(4);
                for (int i = 0; i < 4; ++i) {
                    JsonObject text = textLines.size() > i ? JsonTextUtil.fromNBT(textLines.get(i)) : JsonTextUtil.EMPTY_TEXT_TAG;
                    lines.add(text);
                }
                face.setLines(lines);
            }
        } else {
            ArrayList<JsonElement> lines = new ArrayList<JsonElement>(4);
            for (int i = 1; i <= 4; ++i) {
                lines.add(input.getOptional("Text" + i, Tag.class).map(JsonTextUtil::fromNBT).orElse(JsonTextUtil.EMPTY_TEXT_TAG));
            }
            face.setLines(lines);
        }
        if (input.contains("has_glowing_text")) {
            face.setLit(input.getByte("has_glowing_text", (byte)0) == 1);
        } else {
            face.setLit(input.getByte("GlowingText", (byte)0) == 1);
        }
        if (input.contains("has_glowing_text")) {
            face.setColor(JsonTextUtil.COLOR_TO_BEDROCK_HEX.getOrDefault(input.getString("color", "black"), -16777216));
        } else {
            face.setColor(JsonTextUtil.COLOR_TO_BEDROCK_HEX.getOrDefault(input.getString("Color", "black"), -16777216));
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull SignBlockEntity value) {
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 0)) {
            output.put("is_waxed", value.isWaxed() ? (byte)1 : 0);
            this.writeSignFace(resolvers, output.getOrCreateCompound("front_text"), value.getFront());
            this.writeSignFace(resolvers, output.getOrCreateCompound("back_text"), value.getBack());
        } else {
            this.writeSignFace(resolvers, output, value.getFront());
        }
    }

    protected void writeSignFace(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, SignBlockEntity.SignFace face) {
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 0)) {
            output.put("messages", JsonTextUtil.toNBT(face.getLines(), 4, resolvers.dataVersion()));
            output.put("has_glowing_text", face.isLit() ? (byte)1 : 0);
            output.put("color", JsonTextUtil.COLOR_TO_BEDROCK_HEX.inverse().getOrDefault(face.getColor(), "black"));
        } else {
            for (int i = 0; i < 4; ++i) {
                output.put("Text" + (i + 1), JsonTextUtil.toNBT(face.getLines().size() > i ? face.getLines().get(i) : JsonTextUtil.EMPTY_TEXT_TAG, resolvers.dataVersion()));
            }
            if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 17, 0)) {
                output.put("GlowingText", face.isLit() ? (byte)1 : 0);
            }
            output.put("Color", JsonTextUtil.COLOR_TO_BEDROCK_HEX.inverse().getOrDefault(face.getColor(), "black"));
        }
    }
}

