/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.DecoratedPotBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JavaDecoratedPotBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, DecoratedPotBlockEntity>
implements CustomItemNBTBlockEntityHandler<JavaResolvers, DecoratedPotBlockEntity> {
    public JavaDecoratedPotBlockEntityHandler() {
        super("minecraft:decorated_pot", DecoratedPotBlockEntity.class, DecoratedPotBlockEntity::new);
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull DecoratedPotBlockEntity value) {
        CompoundTag item;
        String tagName = input.contains("sherds") ? "sherds" : "shards";
        List sherds = input.getListValues(tagName, StringTag.class, null);
        if (sherds != null && !sherds.isEmpty()) {
            ArrayList<ChunkerItemStackIdentifier> items = new ArrayList<ChunkerItemStackIdentifier>(sherds.size());
            for (String sherd : sherds) {
                items.add(resolvers.readItemIdentifier(new Identifier(sherd)).getIdentifier());
            }
            value.setBack((ChunkerItemStackIdentifier)items.get(0));
            if (sherds.size() == 1) {
                return;
            }
            value.setLeft((ChunkerItemStackIdentifier)items.get(1));
            if (sherds.size() == 2) {
                return;
            }
            value.setRight((ChunkerItemStackIdentifier)items.get(2));
            if (sherds.size() == 3) {
                return;
            }
            value.setFront((ChunkerItemStackIdentifier)items.get(3));
        }
        if ((item = input.getCompound("item")) != null) {
            value.setItem(resolvers.readItem(item));
        }
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull DecoratedPotBlockEntity value) {
        ListTag<StringTag, String> sherds = new ListTag<StringTag, String>(TagType.STRING, 4);
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getBack())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getLeft())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getRight())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getFront())).getIdentifier()));
        output.put(resolvers.dataVersion().getVersion().isLessThan(1, 20, 0) ? "shards" : "sherds", sherds);
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 3) && value.getItem() != null && !value.getItem().getIdentifier().isAir()) {
            resolvers.writeItem(value.getItem()).ifPresent(item -> output.put("item", (Tag<?>)item));
        }
    }

    @Override
    public boolean generateFromItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull DecoratedPotBlockEntity output, @NotNull CompoundTag input) {
        ListTag containerTag;
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return false;
        }
        CompoundTag components = input.getCompound("components");
        if (components == null) {
            return false;
        }
        List sherds = components.getListValues("minecraft:pot_decorations", StringTag.class, null);
        if (sherds != null && !sherds.isEmpty()) {
            ArrayList<ChunkerItemStackIdentifier> items = new ArrayList<ChunkerItemStackIdentifier>(sherds.size());
            for (String sherd : sherds) {
                items.add(resolvers.readItemIdentifier(new Identifier(sherd)).getIdentifier());
            }
            output.setBack((ChunkerItemStackIdentifier)items.get(0));
            if (sherds.size() == 1) {
                return true;
            }
            output.setLeft((ChunkerItemStackIdentifier)items.get(1));
            if (sherds.size() == 2) {
                return true;
            }
            output.setRight((ChunkerItemStackIdentifier)items.get(2));
            if (sherds.size() == 3) {
                return true;
            }
            output.setFront((ChunkerItemStackIdentifier)items.get(3));
        }
        if ((containerTag = components.getList("minecraft:container", CompoundTag.class, null)) != null) {
            for (CompoundTag itemTag : containerTag) {
                ChunkerItemStack item;
                if ((itemTag = itemTag.getCompound("item")) == null || (item = resolvers.readItem(itemTag)).getIdentifier().isAir()) continue;
                output.setItem(item);
            }
        }
        return true;
    }

    @Override
    public boolean writeToItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull DecoratedPotBlockEntity input, @NotNull CompoundTag output) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return true;
        }
        CompoundTag components = output.getOrCreateCompound("components");
        ListTag<StringTag, String> sherds = new ListTag<StringTag, String>(TagType.STRING, 4);
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(input.getBack())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(input.getLeft())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(input.getRight())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(input.getFront())).getIdentifier()));
        components.put("minecraft:pot_decorations", sherds);
        if (input.getItem() != null && !input.getItem().getIdentifier().isAir()) {
            ListTag items = new ListTag(TagType.COMPOUND, 1);
            Optional<CompoundTag> item = resolvers.writeItem(input.getItem());
            if (item.isPresent()) {
                CompoundTag itemTag = new CompoundTag(2);
                itemTag.put("slot", 0);
                itemTag.put("item", item.get());
                items.add(itemTag);
                components.put("minecraft:container", items);
            }
        }
        return false;
    }
}

