/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.CustomItemNBTBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BannerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerDyeColor;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.banner.ChunkerBannerPattern;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class JavaBannerBlockEntityHandler
extends BlockEntityHandler<JavaResolvers, CompoundTag, BannerBlockEntity>
implements CustomItemNBTBlockEntityHandler<JavaResolvers, BannerBlockEntity> {
    public JavaBannerBlockEntityHandler() {
        super("minecraft:banner", BannerBlockEntity.class, BannerBlockEntity::new);
    }

    @Override
    public void read(@NotNull JavaResolvers resolvers, @NotNull CompoundTag input, @NotNull BannerBlockEntity value) {
        value.setBase(input.getOptionalValue("Base", Integer.class).flatMap(ChunkerDyeColor::getColorByID));
        ListTag patternTags = input.getList("patterns", CompoundTag.class, null);
        if (patternTags == null) {
            patternTags = input.getList("Patterns", CompoundTag.class, null);
        }
        if (patternTags != null) {
            for (CompoundTag patternTag : patternTags) {
                Optional color = patternTag.contains("Color") ? patternTag.getOptionalValue("Color", Integer.class).flatMap(ChunkerDyeColor::getColorByID) : patternTag.getOptionalValue("color", String.class).flatMap(ChunkerDyeColor::getColorByName);
                Optional pattern = patternTag.contains("Pattern") ? patternTag.getOptionalValue("Pattern", String.class).flatMap(resolvers.bannerPatternShortNameResolver()::to) : patternTag.getOptionalValue("pattern", String.class).flatMap(resolvers.bannerPatternResolver()::to);
                if (!color.isPresent() || !pattern.isPresent()) continue;
                value.getPatterns().add(Pair.of((ChunkerDyeColor)((Object)color.get()), (ChunkerBannerPattern)((Object)pattern.get())));
            }
        }
        value.setCustomName(input.getOptional("CustomName", Tag.class).map(JsonTextUtil::fromNBT).orElse(null));
    }

    @Override
    public void write(@NotNull JavaResolvers resolvers, @NotNull CompoundTag output, @NotNull BannerBlockEntity value) {
        if (value.getBase().isPresent()) {
            output.put("Base", value.getBase().get().getID());
        }
        ListTag patternTags = new ListTag(TagType.COMPOUND, value.getPatterns().size());
        for (Pair<ChunkerDyeColor, ChunkerBannerPattern> pair : value.getPatterns()) {
            CompoundTag patternTag = new CompoundTag(2);
            if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 5)) {
                Optional<String> patternIdentifier = resolvers.bannerPatternResolver().from(pair.second());
                if (!patternIdentifier.isPresent()) continue;
                patternTag.put("color", pair.first().getName());
                patternTag.put("pattern", patternIdentifier.get());
                patternTags.add(patternTag);
                continue;
            }
            Optional<String> patternShortName = resolvers.bannerPatternShortNameResolver().from(pair.second());
            if (!patternShortName.isPresent()) continue;
            patternTag.put("Color", pair.first().getID());
            patternTag.put("Pattern", patternShortName.get());
            patternTags.add(patternTag);
        }
        output.put(resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 5) ? "patterns" : "Patterns", patternTags);
        if (value.getCustomName() != null) {
            output.put("CustomName", JsonTextUtil.toNBT(value.getCustomName(), resolvers.dataVersion()));
        }
    }

    @Override
    public boolean generateFromItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull BannerBlockEntity output, @NotNull CompoundTag input) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return false;
        }
        CompoundTag components = input.getCompound("components");
        if (components == null) {
            return false;
        }
        Optional<ChunkerDyeColor> baseColor = components.getOptionalValue("minecraft:base_color", String.class).flatMap(ChunkerDyeColor::getColorByName);
        output.setBase(baseColor);
        ListTag patterns = components.getList("minecraft:banner_patterns", CompoundTag.class, null);
        if (patterns != null) {
            for (CompoundTag patternTag : patterns) {
                Optional color = patternTag.getOptionalValue("color", String.class).flatMap(ChunkerDyeColor::getColorByName);
                Optional pattern = patternTag.getOptionalValue("pattern", String.class).flatMap(resolvers.bannerPatternResolver()::to);
                if (!color.isPresent() || !pattern.isPresent()) continue;
                output.getPatterns().add(Pair.of((ChunkerDyeColor)((Object)color.get()), (ChunkerBannerPattern)((Object)pattern.get())));
            }
        }
        return baseColor.isPresent() || !output.getPatterns().isEmpty();
    }

    @Override
    public boolean writeToItemNBT(@NotNull JavaResolvers resolvers, @NotNull ChunkerItemStack itemStack, @NotNull BannerBlockEntity input, @NotNull CompoundTag output) {
        if (resolvers.dataVersion().getVersion().isLessThan(1, 20, 5)) {
            return true;
        }
        if (input.getBase().isPresent()) {
            output.getOrCreateCompound("components").put("minecraft:base_color", input.getBase().get().getName());
        }
        if (!input.getPatterns().isEmpty()) {
            ListTag patternTags = new ListTag(TagType.COMPOUND, input.getPatterns().size());
            for (Pair<ChunkerDyeColor, ChunkerBannerPattern> pair : input.getPatterns()) {
                Optional<String> patternIdentifier = resolvers.bannerPatternResolver().from(pair.second());
                if (!patternIdentifier.isPresent()) continue;
                CompoundTag patternTag = new CompoundTag(2);
                patternTag.put("color", pair.first().getName());
                patternTag.put("pattern", patternIdentifier.get());
                patternTags.add(patternTag);
            }
            output.getOrCreateCompound("components").put("minecraft:banner_patterns", patternTags);
        }
        return false;
    }
}

