/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.EmptyBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaBannerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaBeaconBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaBrewingStandBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaBrushableBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaCampfireBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaCauldronBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaChiseledBookshelfBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaCommandBlockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaComparatorBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaCrafterBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaDecoratedPotBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaEnchantmentBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaEndGatewayBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaFurnaceBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaJukeboxBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaLecternBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaPistonArmBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaRandomizableContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaSculkSensorBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaShelfBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaSignBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaSkullBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaSpawnerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.blockentity.handlers.JavaStructureBlockEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BedBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BeehiveBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BellBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.ConduitBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.CopperGolemStatueBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.CreakingHeartBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.DaylightDetectorBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.JigsawBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SculkCatalystBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SculkShriekerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.TrialSpawnerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.VaultBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.BlastFurnaceBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.EnderChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.HopperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.SmokerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.BarrelBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DispenserBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DropperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ShulkerBoxBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.TrappedChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.end.EndPortalBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sculksensor.CalibratedSculkSensorBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sign.HangingSignBlockEntity;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Locale;
import java.util.Optional;

public class JavaBlockEntityResolver
extends BlockEntityResolver<JavaResolvers, CompoundTag> {
    public JavaBlockEntityResolver(Version version, JavaResolvers resolvers) {
        super(version, resolvers, resolvers.converter().shouldAllowNBTCopying());
    }

    @Override
    protected void registerTypeHandlers(Version version) {
        this.register(new JavaBlockEntityHandler());
        this.register(new JavaContainerBlockEntityHandler());
        this.register(new JavaRandomizableContainerBlockEntityHandler(((JavaResolvers)this.resolvers).converter().shouldProcessLootTables()));
        this.register(new JavaCauldronBlockEntityHandler());
        this.register(new JavaFurnaceBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("minecraft:chest", ChestBlockEntity.class, ChestBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:trapped_chest", TrappedChestBlockEntity.class, TrappedChestBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:ender_chest", EnderChestBlockEntity.class, EnderChestBlockEntity::new));
        this.register(new JavaJukeboxBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("minecraft:dispenser", DispenserBlockEntity.class, DispenserBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:dropper", DropperBlockEntity.class, DropperBlockEntity::new));
        this.register(new JavaSignBlockEntityHandler());
        this.register(new JavaSpawnerBlockEntityHandler());
        this.register(new JavaPistonArmBlockEntityHandler());
        this.register(new JavaBrewingStandBlockEntityHandler());
        this.register(new JavaEnchantmentBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("minecraft:end_portal", EndPortalBlockEntity.class, EndPortalBlockEntity::new));
        this.register(new JavaBeaconBlockEntityHandler());
        this.register(new JavaSkullBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("minecraft:daylight_detector", DaylightDetectorBlockEntity.class, DaylightDetectorBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:hopper", HopperBlockEntity.class, HopperBlockEntity::new));
        this.register(new JavaComparatorBlockEntityHandler());
        this.register(new JavaBannerBlockEntityHandler());
        this.register(new JavaStructureBlockEntityHandler());
        this.register(new JavaEndGatewayBlockEntityHandler());
        this.register(new JavaCommandBlockBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("minecraft:shulker_box", ShulkerBoxBlockEntity.class, ShulkerBoxBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:bed", BedBlockEntity.class, BedBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("minecraft:conduit", ConduitBlockEntity.class, ConduitBlockEntity::new));
        if (version.isGreaterThanOrEqual(1, 14, 0)) {
            this.register(new JavaCampfireBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("minecraft:jigsaw", JigsawBlockEntity.class, JigsawBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("minecraft:bell", BellBlockEntity.class, BellBlockEntity::new));
            this.register(new JavaLecternBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("minecraft:blast_furnace", BlastFurnaceBlockEntity.class, BlastFurnaceBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("minecraft:smoker", SmokerBlockEntity.class, SmokerBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("minecraft:barrel", BarrelBlockEntity.class, BarrelBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 15, 0)) {
            this.register(new EmptyBlockEntityHandler("minecraft:beehive", BeehiveBlockEntity.class, BeehiveBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 17, 0)) {
            this.register(new JavaSculkSensorBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 19, 0)) {
            this.register(new EmptyBlockEntityHandler("minecraft:sculk_catalyst", SculkCatalystBlockEntity.class, SculkCatalystBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("minecraft:sculk_shrieker", SculkShriekerBlockEntity.class, SculkShriekerBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 19, 3)) {
            this.register(new JavaChiseledBookshelfBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 19, 4)) {
            this.register(new JavaBrushableBlockEntityHandler());
            this.register(new JavaDecoratedPotBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 20, 0)) {
            this.register(new EmptyBlockEntityHandler("minecraft:hanging_sign", HangingSignBlockEntity.class, HangingSignBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("minecraft:calibrated_sculk_sensor", CalibratedSculkSensorBlockEntity.class, CalibratedSculkSensorBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 20, 3)) {
            this.register(new JavaCrafterBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("minecraft:trial_spawner", TrialSpawnerBlockEntity.class, TrialSpawnerBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 20, 5)) {
            this.register(new EmptyBlockEntityHandler("minecraft:vault", VaultBlockEntity.class, VaultBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 21, 2)) {
            this.register(new EmptyBlockEntityHandler("minecraft:creaking_heart", CreakingHeartBlockEntity.class, CreakingHeartBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 21, 9)) {
            this.register(new JavaShelfBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("minecraft:copper_golem_statue", CopperGolemStatueBlockEntity.class, CopperGolemStatueBlockEntity::new));
        }
    }

    @Override
    protected CompoundTag constructDataType(String key) {
        CompoundTag compoundTag = new CompoundTag(4);
        compoundTag.put("id", key);
        return compoundTag;
    }

    @Override
    public Optional<String> getKey(CompoundTag input) {
        return input.getOptionalValue("id", String.class).map(a -> a.toLowerCase(Locale.ROOT)).map(a -> !a.contains(":") ? "minecraft:" + a : a);
    }
}

