/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader.util;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.nbt.io.Reader;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;

public class MCAReader
implements AutoCloseable {
    private final Converter converter;
    private final File folder;
    private final RandomAccessFile randomAccessFile;
    private final Reader reader;

    public MCAReader(Converter converter, File file) throws FileNotFoundException {
        this.converter = converter;
        this.folder = file.getParentFile();
        this.randomAccessFile = new RandomAccessFile(file, "r");
        this.reader = Reader.toJavaReader(this.randomAccessFile);
    }

    public int[] readOffsetTable() throws IOException {
        int[] offsets = new int[1024];
        byte[] temp = new byte[4096];
        this.reader.readBytes(temp);
        for (int i = 0; i < 1024; ++i) {
            int tempIndex = i << 2;
            int offset = (temp[tempIndex] & 0xFF) << 16 | (temp[tempIndex + 1] & 0xFF) << 8 | temp[tempIndex + 2] & 0xFF;
            if (offset <= 0) continue;
            offsets[i] = offset;
        }
        return offsets;
    }

    public Task<CompoundTag> readColumn(ChunkCoordPair columnCoordPair, int offset) throws IOException {
        byte[] compressedColumn;
        this.randomAccessFile.seek((long)offset * 4096L);
        int chunkLength = this.reader.readInt() - 1;
        byte rawType = this.reader.readByte();
        byte compressionType = (byte)(rawType & 0xFFFFFF7F);
        if ((rawType & 0x80) != 0) {
            File file = new File(this.folder, "c." + columnCoordPair.chunkX() + "." + columnCoordPair.chunkZ() + ".mcc");
            compressedColumn = Files.readAllBytes(file.toPath());
        } else {
            compressedColumn = new byte[chunkLength];
            this.reader.readBytes(compressedColumn);
        }
        return Task.async("Decompressing column data", TaskWeight.HIGH, () -> this.decompressColumn(columnCoordPair, compressionType, compressedColumn));
    }

    protected CompoundTag decompressColumn(ChunkCoordPair chunkCoordPair, byte compressionType, byte[] compressedColumn) throws IOException {
        try {
            return switch (compressionType) {
                case 0 -> null;
                case 1 -> Tag.readGZipJavaNBT(compressedColumn);
                case 2 -> Tag.readZLibJavaNBT(compressedColumn);
                case 3 -> Tag.readUncompressedJavaNBT(compressedColumn);
                case 4 -> Tag.readLZ4JavaNBT(compressedColumn);
                default -> {
                    this.converter.logNonFatalException(new Exception("Unsupported Chunk Compression Type " + compressionType));
                    yield null;
                }
            };
        }
        catch (Exception e) {
            throw new IOException("Failed to decompress column %s inside %s".formatted(chunkCoordPair, chunkCoordPair.getRegion()), e);
        }
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }
}

