/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyChestPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyDoorPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyFenceGatePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyFirePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyNoteBlockPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyRedstonePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyStairShapePreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyStemPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyTallPlantsPreTransformHandler;
import com.hivemc.chunker.conversion.encoding.java.base.reader.pretransform.legacy.handlers.JavaLegacyWallPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.ConnectableBlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.HorizontalConnectableBlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockGroups;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JavaLegacyReaderPreTransformManager
extends PreTransformManager {
    public static final Set<ChunkerBlockType> TALL_PLANTS = Set.of(ChunkerVanillaBlockType.SUNFLOWER, ChunkerVanillaBlockType.LILAC, ChunkerVanillaBlockType.TALL_GRASS, ChunkerVanillaBlockType.LARGE_FERN, ChunkerVanillaBlockType.ROSE_BUSH, ChunkerVanillaBlockType.PEONY);

    public JavaLegacyReaderPreTransformManager(Version version) {
        super(version);
    }

    @Override
    public void registerHandlers(Version version) {
        this.registerHandler(new JavaLegacyChestPreTransformHandler(), ChunkerVanillaBlockType.CHEST, ChunkerVanillaBlockType.TRAPPED_CHEST);
        this.registerHandler(new JavaLegacyTallPlantsPreTransformHandler(), TALL_PLANTS);
        this.registerHandler(new JavaLegacyStemPreTransformHandler(Set.of(ChunkerVanillaBlockType.MELON)), ChunkerVanillaBlockType.ATTACHED_MELON_STEM, new ChunkerBlockType[0]);
        this.registerHandler(new JavaLegacyStemPreTransformHandler(Set.of(ChunkerVanillaBlockType.PUMPKIN)), ChunkerVanillaBlockType.ATTACHED_PUMPKIN_STEM, new ChunkerBlockType[0]);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE) || relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE_HOOK);
            }
        }, ChunkerVanillaBlockType.TRIPWIRE, new ChunkerBlockType[0]);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                if (ChunkerVanillaBlockGroups.FENCE_GATES.contains(relative.getType())) {
                    FacingDirectionHorizontal facing = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
                    return Objects.requireNonNull(facing).isAdjacent(direction.asFacingDirectionHorizontal());
                }
                return ChunkerVanillaBlockGroups.WOODEN_FENCES.contains(relative.getType()) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockGroups.WOODEN_FENCES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                if (ChunkerVanillaBlockGroups.FENCE_GATES.contains(relative.getType())) {
                    FacingDirectionHorizontal facing = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
                    return Objects.requireNonNull(facing).isAdjacent(direction.asFacingDirectionHorizontal());
                }
                return relative.getType().equals(ChunkerVanillaBlockType.NETHER_BRICK_FENCE) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockType.NETHER_BRICK_FENCE, new ChunkerBlockType[0]);
        this.registerHandler(new JavaLegacyFenceGatePreTransformHandler(), ChunkerVanillaBlockGroups.FENCE_GATES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return ChunkerVanillaBlockGroups.BARS_AND_GLASS_PANES.contains(relative.getType()) || ChunkerVanillaBlockGroups.WALLS.contains(relative.getType()) || relative.getType().isAllFacesSolid();
            }
        }, ChunkerVanillaBlockGroups.BARS_AND_GLASS_PANES);
        this.registerHandler(new HorizontalConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(source.getType()) || relative.getType().equals(ChunkerVanillaBlockType.TRIPWIRE_HOOK);
            }
        }, ChunkerVanillaBlockType.TRIPWIRE, new ChunkerBlockType[0]);
        this.registerHandler(new ConnectableBlockPreTransformHandler(){

            @Override
            public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
                return relative.getType().equals(source.getType()) || relative.getType().equals(ChunkerVanillaBlockType.CHORUS_FLOWER) || direction == BlockPreTransformHandler.Direction.DOWN && relative.getType().equals(ChunkerVanillaBlockType.END_STONE);
            }
        }, ChunkerVanillaBlockType.CHORUS_PLANT, new ChunkerBlockType[0]);
        this.registerHandler(new JavaLegacyWallPreTransformHandler(), ChunkerVanillaBlockGroups.WALLS);
        this.registerHandler(new BlockPreTransformHandler(){

            @Override
            public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
                return Collections.emptySet();
            }

            @Override
            public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
                ChunkerBlockIdentifier aboveIdentifier = column.getBlock(x, y + 1, z);
                blockIdentifier = ChunkerVanillaBlockGroups.SNOWY_BLOCKS.contains(aboveIdentifier.getType()) ? blockIdentifier.copyWith(VanillaBlockStates.SNOWY, Bool.TRUE) : blockIdentifier.copyWith(VanillaBlockStates.SNOWY, Bool.FALSE);
                return blockIdentifier;
            }
        }, ChunkerVanillaBlockGroups.SNOWY_GRASS_BLOCKS);
        this.registerHandler(new JavaLegacyDoorPreTransformHandler(), ChunkerVanillaBlockGroups.DOORS);
        this.registerHandler(new JavaLegacyStairShapePreTransformHandler(), ChunkerVanillaBlockGroups.STAIRS);
        this.registerHandler(new JavaLegacyRedstonePreTransformHandler(), ChunkerVanillaBlockType.REDSTONE_WIRE, new ChunkerBlockType[0]);
        this.registerHandler(new JavaLegacyNoteBlockPreTransformHandler(), ChunkerVanillaBlockType.NOTE_BLOCK, new ChunkerBlockType[0]);
        this.registerHandler(new JavaLegacyFirePreTransformHandler(), ChunkerVanillaBlockType.FIRE, new ChunkerBlockType[0]);
    }
}

