/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.reader.WorldReader;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaColumnReader;
import com.hivemc.chunker.conversion.encoding.java.base.reader.util.MCAReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JavaWorldReader
implements WorldReader {
    protected final Converter converter;
    protected final JavaResolvers resolvers;
    protected final File dimensionFolder;
    protected final Dimension dimension;

    public JavaWorldReader(Converter converter, JavaResolvers resolvers, File dimensionFolder, Dimension dimension) {
        this.converter = converter;
        this.resolvers = resolvers;
        this.dimensionFolder = dimensionFolder;
        this.dimension = dimension;
    }

    @Override
    public void readWorld(WorldConversionHandler worldConversionHandler) {
        ObjectOpenHashSet<RegionCoordPair> regions = new ObjectOpenHashSet<RegionCoordPair>();
        ChunkerWorld chunkerWorld = new ChunkerWorld(this.dimension, regions);
        File[] folders = this.getMCAFolders();
        ObjectOpenHashSet knownRegionFiles = new ObjectOpenHashSet();
        for (File folder : folders) {
            File[] regionFiles = folder.listFiles((parent, fileName) -> fileName.endsWith(".mca"));
            if (regionFiles == null) continue;
            for (File regionFile : regionFiles) {
                String[] parts = regionFile.getName().split("\\.");
                if (parts.length != 4 || regionFile.length() < 4096L) continue;
                knownRegionFiles.add(regionFile.getAbsolutePath());
                try {
                    int x = Integer.parseInt(parts[1]);
                    int z = Integer.parseInt(parts[2]);
                    regions.add(new RegionCoordPair(x, z));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        HashSet<RegionCoordPair> regionsCopy = new HashSet<RegionCoordPair>(regions);
        Task<ColumnConversionHandler> convertWorld = worldConversionHandler.convertWorld(chunkerWorld);
        ProgressiveTask<Void> regionProcessing = convertWorld.thenConsume("Reading regions", TaskWeight.HIGHER, columnConversionHandler -> {
            if (columnConversionHandler == null) {
                return;
            }
            ProgressiveTask<Void> readingRegionFiles = Task.async("Reading region files", TaskWeight.HIGHER, () -> this.readRegionFiles((Set<RegionCoordPair>)regionsCopy, knownRegionFiles, (ColumnConversionHandler)columnConversionHandler));
            readingRegionFiles.then("Flushing columns", TaskWeight.MEDIUM, columnConversionHandler::flushColumns);
        });
        regionProcessing.then("Flushing world", TaskWeight.MEDIUM, () -> worldConversionHandler.flushWorld(chunkerWorld));
    }

    protected void readRegionFiles(Set<RegionCoordPair> regions, Set<String> knownRegionFiles, ColumnConversionHandler columnConversionHandler) {
        for (RegionCoordPair region : regions) {
            if (!this.converter.shouldProcessRegion(this.dimension, region)) continue;
            File[] regionFiles = this.getRegionFiles(region, knownRegionFiles);
            Task.async("Reading region file", TaskWeight.NORMAL, () -> this.readRegion(regionFiles, region, columnConversionHandler)).then("Region - Flushing", TaskWeight.MEDIUM, () -> columnConversionHandler.flushRegion(region)).then("Region - System::GC", TaskWeight.NONE, System::gc);
        }
    }

    protected File[] getMCAFolders() {
        return new File[]{new File(this.dimensionFolder, "region")};
    }

    @Nullable
    protected File[] getRegionFiles(RegionCoordPair region, Set<String> knownFiles) {
        File[] folders = this.getMCAFolders();
        File[] files = new File[folders.length];
        File[] mcaFolders = this.getMCAFolders();
        for (int i = 0; i < mcaFolders.length; ++i) {
            File folder = mcaFolders[i];
            File temp = new File(folder, "r." + region.regionX() + "." + region.regionZ() + ".mca");
            if (!knownFiles.contains(temp.getAbsolutePath())) continue;
            files[i] = temp;
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void readRegion(@Nullable File[] regionFiles, RegionCoordPair region, ColumnConversionHandler columnConversionHandler) {
        MCAReader[] mcaReaders;
        int regionFilesCount;
        block24: {
            void var9_19;
            regionFilesCount = regionFiles.length;
            mcaReaders = new MCAReader[regionFilesCount];
            boolean foundValidFile = false;
            for (int i = 0; i < regionFilesCount; ++i) {
                File file = regionFiles[i];
                if (file == null) continue;
                try {
                    mcaReaders[i] = new MCAReader(this.converter, file);
                    foundValidFile = true;
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (foundValidFile) break block24;
            this.converter.logNonFatalException(new Exception("Misnamed region file for " + String.valueOf((Object)this.dimension) + ", " + String.valueOf(region)));
            MCAReader[] i = mcaReaders;
            int file = i.length;
            boolean bl = false;
            while (var9_19 < file) {
                MCAReader mcaReader = i[var9_19];
                if (mcaReader != null) {
                    try {
                        mcaReader.close();
                    }
                    catch (IOException e) {
                        this.converter.logNonFatalException(e);
                    }
                }
                ++var9_19;
            }
            return;
        }
        try {
            Int2ObjectOpenHashMap<int[]> positionsToOffsets = new Int2ObjectOpenHashMap<int[]>();
            for (int regionFileIndex = 0; regionFileIndex < regionFilesCount; ++regionFileIndex) {
                MCAReader mCAReader = mcaReaders[regionFileIndex];
                if (mCAReader == null) continue;
                try {
                    int[] offsets = mCAReader.readOffsetTable();
                    for (int i = 0; i < offsets.length; ++i) {
                        int offset = offsets[i];
                        if (offset <= 0) continue;
                        int[] mcaOffsets = positionsToOffsets.computeIfAbsent(i, ignored -> new int[regionFilesCount]);
                        mcaOffsets[regionFileIndex] = offset;
                    }
                    continue;
                }
                catch (Exception e) {
                    this.converter.logNonFatalException(e);
                }
            }
            for (Int2ObjectMap.Entry entry : positionsToOffsets.int2ObjectEntrySet()) {
                ChunkCoordPair localCoords = new ChunkCoordPair(entry.getIntKey() & 0x1F, entry.getIntKey() >> 5);
                ChunkCoordPair columnsCoords = region.getChunk(localCoords.chunkX(), localCoords.chunkZ());
                if (!this.converter.shouldProcessColumn(this.dimension, columnsCoords)) continue;
                ArrayList<Task<CompoundTag>> decompressingTasks = new ArrayList<Task<CompoundTag>>(regionFilesCount);
                ArrayList<Integer> decompressingTasksIndexes = new ArrayList<Integer>(regionFilesCount);
                for (int regionFileIndex = 0; regionFileIndex < regionFilesCount; ++regionFileIndex) {
                    int offset;
                    MCAReader mcaReader = mcaReaders[regionFileIndex];
                    if (mcaReader == null || (offset = ((int[])entry.getValue())[regionFileIndex]) <= 0) continue;
                    try {
                        decompressingTasks.add(mcaReader.readColumn(columnsCoords, offset));
                        decompressingTasksIndexes.add(regionFileIndex);
                        continue;
                    }
                    catch (Exception e) {
                        this.converter.logNonFatalException(e);
                    }
                }
                Task.join(decompressingTasks).then("Combining input column NBT", TaskWeight.LOW, results -> {
                    CompoundTag[] compoundTags = new CompoundTag[regionFilesCount];
                    for (int i = 0; i < decompressingTasksIndexes.size(); ++i) {
                        compoundTags[((Integer)decompressingTasksIndexes.get((int)i)).intValue()] = (CompoundTag)results.get(i);
                    }
                    return this.combineColumnCompounds(compoundTags);
                }).then("Creating Column Reader", TaskWeight.LOW, column -> this.createColumnReader(columnsCoords, (CompoundTag)column)).thenConsume("Reading Column", TaskWeight.HIGHER, columnReader -> columnReader.readColumn(columnConversionHandler));
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            for (MCAReader mCAReader : mcaReaders) {
                if (mCAReader == null) continue;
                try {
                    mCAReader.close();
                }
                catch (IOException e) {
                    this.converter.logNonFatalException(e);
                }
            }
        }
    }

    protected CompoundTag combineColumnCompounds(CompoundTag[] compoundTags) {
        if (compoundTags.length > 1) {
            throw new IllegalArgumentException("Combining compounds is unsupported at this version");
        }
        return compoundTags[0];
    }

    public JavaColumnReader createColumnReader(ChunkCoordPair worldChunkCoords, CompoundTag columnNBT) {
        return new JavaColumnReader(this.converter, this.resolvers, this.dimension, worldChunkCoords, columnNBT);
    }
}

