/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.java.base.JavaReaderWriter;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaWorldReader;
import com.hivemc.chunker.conversion.encoding.java.base.reader.util.MCAReader;
import com.hivemc.chunker.conversion.encoding.java.base.resolver.JavaResolvers;
import com.hivemc.chunker.conversion.handlers.LevelConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerPortal;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.DoubleTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import com.hivemc.chunker.scheduling.task.FutureTask;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.util.BlockPosition;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLevelReader
implements LevelReader,
JavaReaderWriter {
    public static final Map<Byte, String> SLOT_TO_EQUIPMENT = Map.of((byte)-106, "offhand", (byte)100, "feet", (byte)101, "legs", (byte)102, "chest", (byte)103, "head");
    protected final File inputDirectory;
    protected final Version inputVersion;
    protected final Converter converter;
    protected final JavaResolvers resolvers;

    public JavaLevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        this.inputDirectory = inputDirectory;
        this.inputVersion = inputVersion;
        this.converter = converter;
        this.resolvers = this.buildResolvers(converter).build();
    }

    public static File getDimensionBaseDirectory(File directory, Dimension dimension) {
        return switch (dimension) {
            default -> throw new IncompatibleClassChangeError();
            case Dimension.OVERWORLD -> directory;
            case Dimension.NETHER -> new File(directory, "DIM-1");
            case Dimension.THE_END -> new File(directory, "DIM1");
        };
    }

    @Override
    public void readLevel(LevelConversionHandler levelConversionHandler) {
        FutureTask levelDataCollection = Task.asyncUnwrap("Collecting Level Data", TaskWeight.MEDIUM, this::collectLevelData, levelConversionHandler);
        ProgressiveTask<Void> worldReading = levelDataCollection.thenConsume("Reading Worlds", TaskWeight.HIGHEST, worldConversionHandler -> {
            if (worldConversionHandler == null) {
                return;
            }
            ArrayList<ProgressiveTask<Void>> worlds = new ArrayList<ProgressiveTask<Void>>(3);
            for (Dimension dimension : Dimension.values()) {
                File dimensionBaseDirectory = JavaLevelReader.getDimensionBaseDirectory(this.inputDirectory, dimension);
                if (!dimensionBaseDirectory.exists() || !this.converter.shouldProcessDimension(dimension)) continue;
                JavaWorldReader reader = this.createWorldReader(dimensionBaseDirectory, dimension);
                worlds.add(Task.asyncConsume("Reading World", TaskWeight.HIGHER, reader::readWorld, worldConversionHandler));
            }
            Task.join(worlds).then("Flushing Worlds", TaskWeight.MEDIUM, worldConversionHandler::flushWorlds);
        });
        worldReading.then("Flushing Level", TaskWeight.MEDIUM, levelConversionHandler::flushLevel);
    }

    protected Task<WorldConversionHandler> collectLevelData(LevelConversionHandler levelConversionHandler) {
        ChunkerLevel output = new ChunkerLevel();
        ProgressiveTask<Void> parseLevelSettings = Task.asyncConsume("Parsing Level Settings", TaskWeight.NORMAL, this::parseLevelSettings, output);
        ProgressiveTask<Void> parseMaps = Task.asyncConsume("Parsing Saved Maps", TaskWeight.NORMAL, this::parseMaps, output);
        ProgressiveTask<Void> parsePOI = Task.asyncConsume("Parsing POIs", TaskWeight.NORMAL, this::parsePOI, output);
        return Task.join(parseLevelSettings, parseMaps, parsePOI).thenUnwrap("Converting Level", TaskWeight.LOW, levelConversionHandler::convertLevel, (List<ChunkerLevel>)((Object)output));
    }

    protected void parsePOI(ChunkerLevel output) throws Exception {
        output.setPortals(Collections.synchronizedList(new ArrayList()));
        for (Dimension dimension : Dimension.values()) {
            File[] mcaFiles;
            File poiBaseDirectory = new File(JavaLevelReader.getDimensionBaseDirectory(this.inputDirectory, dimension), "poi");
            if (!poiBaseDirectory.exists() || !this.converter.shouldProcessDimension(dimension) || (mcaFiles = poiBaseDirectory.listFiles((parent, fileName) -> fileName.endsWith(".mca"))) == null) continue;
            List collectedPOIs = Collections.synchronizedList(new ArrayList());
            FutureTask<Void> task = Task.asyncConsumeForEach("Reading POI region", TaskWeight.NORMAL, file -> this.parsePOI(dimension, (File)file, collectedPOIs), mcaFiles);
            task.then("Processing Dimension POIs", TaskWeight.NORMAL, () -> output.getPortals().addAll(this.collectPortals(dimension, collectedPOIs)));
        }
    }

    protected List<ChunkerPortal> collectPortals(Dimension dimension, List<CompoundTag> collectedPOIs) {
        ArrayList<ChunkerPortal> portals = new ArrayList<ChunkerPortal>();
        ArrayList<List<BlockPosition>> portalPositions = new ArrayList<List<BlockPosition>>();
        for (CompoundTag compoundTag : collectedPOIs) {
            int[] pos;
            String type = compoundTag.getString("type", null);
            if (!"minecraft:nether_portal".equals(type) || (pos = compoundTag.getIntArray("pos", null)) == null || pos.length != 3) continue;
            BlockPosition entry = new BlockPosition(pos[0], pos[1], pos[2]);
            List<BlockPosition> list = this.findAdjacentPortalBlock(portalPositions, entry);
            if (list == null) {
                list = new ArrayList<BlockPosition>(1);
                portalPositions.add(list);
            }
            list.add(entry);
        }
        for (List list : portalPositions) {
            try {
                if (list.size() < 2) continue;
                list.sort(BlockPosition.BY_Y_X_Z);
                BlockPosition bottomLeft = (BlockPosition)list.get(0);
                BlockPosition nextToBottomLeft = (BlockPosition)list.get(1);
                byte width = (byte)list.stream().filter(position -> position.y() == bottomLeft.y()).count();
                ChunkerPortal portal = new ChunkerPortal(dimension, bottomLeft.x(), bottomLeft.y(), bottomLeft.z(), width, (byte)Math.abs(bottomLeft.x() - nextToBottomLeft.x()), (byte)Math.abs(bottomLeft.z() - nextToBottomLeft.z()));
                portals.add(portal);
            }
            catch (Exception e) {
                this.converter.logNonFatalException(e);
            }
        }
        return portals;
    }

    @Nullable
    protected List<BlockPosition> findAdjacentPortalBlock(List<List<BlockPosition>> portalPositions, BlockPosition matcher) {
        for (List<BlockPosition> positions : portalPositions) {
            for (BlockPosition entry : positions) {
                int difference = Math.abs(entry.x() - matcher.x()) + Math.abs(entry.y() - matcher.y()) + Math.abs(entry.z() - matcher.z());
                if (difference > 2) continue;
                return positions;
            }
        }
        return null;
    }

    protected void parsePOI(Dimension dimension, File file, List<CompoundTag> collectedPOIs) throws Exception {
        RegionCoordPair regionCoordPair;
        String[] parts = file.getName().split("\\.");
        if (parts.length != 4 || file.length() < 4096L) {
            return;
        }
        try {
            int regionX = Integer.parseInt(parts[1]);
            int regionZ = Integer.parseInt(parts[2]);
            regionCoordPair = new RegionCoordPair(regionX, regionZ);
        }
        catch (NumberFormatException e) {
            return;
        }
        try (MCAReader mcaReader = new MCAReader(this.converter, file);){
            int[] offsets = mcaReader.readOffsetTable();
            for (int i = 0; i < offsets.length; ++i) {
                ChunkCoordPair localCoords;
                ChunkCoordPair columnsCoords;
                int offset = offsets[i];
                if (offset <= 0 || !this.converter.shouldProcessColumn(dimension, columnsCoords = regionCoordPair.getChunk((localCoords = new ChunkCoordPair(i & 0x1F, i >> 5)).chunkX(), localCoords.chunkZ()))) continue;
                mcaReader.readColumn(columnsCoords, offset).thenConsume("Parsing POI Region", TaskWeight.NORMAL, compound -> this.collectColumnPOIs((CompoundTag)compound, collectedPOIs));
            }
        }
    }

    protected void collectColumnPOIs(@Nullable CompoundTag column, List<CompoundTag> collectedPOIs) throws Exception {
        if (column == null) {
            return;
        }
        CompoundTag sections = column.getCompound("Sections");
        if (sections == null) {
            return;
        }
        for (Map.Entry<String, Tag<?>> section : sections) {
            ListTag records;
            CompoundTag sectionTag;
            byte valid;
            Tag<?> tag = section.getValue();
            if (!(tag instanceof CompoundTag) || (valid = (sectionTag = (CompoundTag)tag).getByte("Valid", (byte)0)) != 1 || (records = sectionTag.getList("Records", CompoundTag.class, null)) == null) continue;
            collectedPOIs.addAll(records.getValue());
        }
    }

    protected void parseLevelSettings(ChunkerLevel output) throws Exception {
        CompoundTag level = Tag.readGZipJavaNBT(new File(this.inputDirectory, "level.dat"));
        CompoundTag preparedLevel = this.prepareNBTForLevelSettings(level);
        output.setSettings(ChunkerLevelSettings.fromNBT(Objects.requireNonNull(preparedLevel), this, this.converter));
        output.setOriginalLevelData(level);
        try {
            output.setPlayer(this.parsePlayer(preparedLevel));
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
    }

    protected CompoundTag prepareNBTForLevelSettings(CompoundTag level) throws Exception {
        return level;
    }

    @Nullable
    protected ChunkerLevelPlayer parsePlayer(CompoundTag level) throws Exception {
        CompoundTag equipment;
        ChunkerItemStack item;
        CompoundTag player = level.getCompound("Player");
        if (player == null) {
            return null;
        }
        List<Double> positions = player.getListValues("Pos", DoubleTag.class, List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)));
        List<Double> motion = player.getListValues("Motion", DoubleTag.class, List.of(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)));
        List<Float> rotation = player.getListValues("Rotation", FloatTag.class, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f)));
        Byte2ObjectAVLTreeMap<ChunkerItemStack> inventory = new Byte2ObjectAVLTreeMap<ChunkerItemStack>();
        ListTag items = player.getList("Inventory", CompoundTag.class, null);
        if (items != null) {
            byte index = 0;
            for (CompoundTag compoundTag : items) {
                byte slot = compoundTag.getByte("Slot", index);
                item = this.resolvers.readItem(compoundTag);
                inventory.put(slot, item);
                index = (byte)(index + 1);
            }
        }
        if ((equipment = player.getCompound("equipment")) != null) {
            for (Map.Entry entry : SLOT_TO_EQUIPMENT.entrySet()) {
                CompoundTag itemTag = equipment.getCompound((String)entry.getValue());
                if (itemTag == null) continue;
                item = this.resolvers.readItem(itemTag);
                inventory.put((byte)((Byte)entry.getKey()), item);
            }
        }
        return new ChunkerLevelPlayer(Dimension.fromJavaNBT(player.get("Dimension"), Dimension.OVERWORLD), positions.get(0), positions.get(1), positions.get(2), motion.get(0), motion.get(1), motion.get(2), rotation.get(0).floatValue(), rotation.get(1).floatValue(), inventory, player.getInt("playerGameType", 0));
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (targetName.equals("AutumnDrop2025")) {
            return false;
        }
        if (targetName.equals("SummerDrop2025")) {
            return false;
        }
        if (targetName.equals("WinterDrop2024")) {
            return false;
        }
        if (targetName.equals("R21Support")) {
            return false;
        }
        if (targetName.equals("R20Support")) {
            return false;
        }
        if (targetName.equals("CavesAndCliffs")) {
            return false;
        }
        if (targetName.equals("FlatWorldVersion")) {
            return 0;
        }
        if (targetName.equals("RandomSeed")) {
            return root.contains(targetName) ? String.valueOf(root.getLong(targetName)) : null;
        }
        if (type == ChunkerGeneratorType.class) {
            if (!root.contains("generatorName")) {
                return ChunkerGeneratorType.NORMAL;
            }
            String generatorName = root.getString("generatorName");
            if (generatorName.equals("default")) {
                return ChunkerGeneratorType.CUSTOM;
            }
            if (generatorName.equals("flat")) {
                if (root.contains("generatorOptions") && !root.getString("generatorOptions").isEmpty()) {
                    if (root.getString("generatorOptions").startsWith("3;minecraft:air;127;")) {
                        return ChunkerGeneratorType.VOID;
                    }
                    return ChunkerGeneratorType.CUSTOM;
                }
                return ChunkerGeneratorType.FLAT;
            }
            return ChunkerGeneratorType.CUSTOM;
        }
        throw new IllegalArgumentException("Type " + targetName + " isn't implemented for setting parsing");
    }

    @Override
    public Version getVersion() {
        return this.inputVersion;
    }

    protected void parseMaps(ChunkerLevel output) {
        File[] mapFiles;
        File dataDirectory;
        ArrayList<ChunkerMap> maps = new ArrayList<ChunkerMap>();
        if (this.converter.shouldProcessMaps() && (dataDirectory = new File(this.inputDirectory, "data")).isDirectory() && (mapFiles = dataDirectory.listFiles((dir, name) -> name.startsWith("map_") && name.endsWith(".dat"))) != null) {
            FutureTask<ChunkerMap[]> parsingTask = Task.asyncForEach("Parsing map", TaskWeight.NORMAL, this::parseMap, ChunkerMap[]::new, mapFiles);
            parsingTask.thenConsume("Parsing map sync", TaskWeight.LOW, mapArray -> {
                for (ChunkerMap map : mapArray) {
                    if (map == null) continue;
                    maps.add(map);
                }
                maps.sort(ChunkerMap.BY_ID_COMPARATOR);
            });
        }
        output.setMaps(maps);
    }

    @Nullable
    protected ChunkerMap parseMap(File mapFile) {
        try {
            CompoundTag mapCompound = Tag.readPossibleGZipJavaNBT(mapFile);
            if (mapCompound == null) {
                return null;
            }
            String idString = mapFile.getName().substring(4, mapFile.getName().length() - 4);
            int id = Integer.parseInt(idString);
            ChunkerMap map = new ChunkerMap(id, id, mapCompound.getShort("height", (short)128), mapCompound.getShort("width", (short)128), mapCompound.getByte("scale", (byte)0), Dimension.fromJavaNBT(mapCompound.get("dimension"), Dimension.OVERWORLD), mapCompound.getInt("xCenter", 0), mapCompound.getInt("zCenter", 0), mapCompound.getByte("unlimitedTracking", (byte)0) != 0, mapCompound.getByte("locked", (byte)0) != 0, null, this.resolvers.converter().shouldAllowNBTCopying() ? mapCompound : null);
            if (mapCompound.contains("colors")) {
                map.setBytes(this.resolvers.readMapColors(mapCompound.getByteArray("colors")));
            }
            return map;
        }
        catch (Exception e) {
            this.converter.logNonFatalException(new Exception("Could not read map " + mapFile.getName(), e));
            return null;
        }
    }

    public JavaWorldReader createWorldReader(File dimensionFolder, Dimension dimension) {
        return new JavaWorldReader(this.converter, this.resolvers, dimensionFolder, dimension);
    }
}

