/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.java.JavaDataVersion;
import com.hivemc.chunker.conversion.encoding.java.JavaLevelReaderConstructor;
import com.hivemc.chunker.conversion.encoding.java.JavaLevelWriterConstructor;
import com.hivemc.chunker.conversion.encoding.java.base.reader.JavaLevelReader;
import com.hivemc.chunker.conversion.encoding.java.base.writer.JavaLevelWriter;
import com.hivemc.chunker.conversion.encoding.java.v1_20_3.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.java.v1_21_6.writer.LevelWriter;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class JavaEncoders {
    private static final TreeMap<JavaDataVersion, JavaEncoder> ENCODER_LOOKUP = new TreeMap();

    public static void register(JavaDataVersion dataVersion, JavaLevelReaderConstructor<?> readerConstructor, JavaLevelWriterConstructor<?> writerConstructor) {
        ENCODER_LOOKUP.put(dataVersion, new JavaEncoder(readerConstructor, writerConstructor));
    }

    public static JavaEncoder oldest() {
        return ENCODER_LOOKUP.firstEntry().getValue();
    }

    public static JavaEncoder latest() {
        return ENCODER_LOOKUP.lastEntry().getValue();
    }

    public static Collection<Version> getSupportedVersions() {
        return JavaDataVersion.getVersions().stream().map(JavaDataVersion::getVersion).collect(Collectors.toList());
    }

    public static JavaEncoder getNearestEncoder(JavaDataVersion dataVersion) {
        Map.Entry<JavaDataVersion, JavaEncoder> entry = ENCODER_LOOKUP.floorEntry(dataVersion);
        return entry == null ? JavaEncoders.oldest() : entry.getValue();
    }

    public static Optional<JavaLevelReader> createReader(File directory, Converter converter) {
        Optional<JavaDataVersion> javaDataVersion = JavaDataVersion.detect(directory);
        if (javaDataVersion.isEmpty()) {
            return Optional.empty();
        }
        JavaDataVersion dataVersion = javaDataVersion.get();
        JavaEncoder nearest = JavaEncoders.getNearestEncoder(dataVersion);
        if (nearest == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nearest.readerConstructor().construct(directory, dataVersion.getVersion(), converter));
    }

    public static Optional<JavaLevelWriter> createWriter(File directory, Version outputVersion, Converter converter) {
        JavaDataVersion dataVersion = JavaDataVersion.getNearestVersion(outputVersion);
        if (dataVersion == null) {
            return Optional.empty();
        }
        JavaEncoder nearest = JavaEncoders.getNearestEncoder(dataVersion);
        if (nearest == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nearest.writerConstructor().construct(directory, dataVersion.getVersion(), converter));
    }

    static {
        JavaEncoders.register(JavaDataVersion.V1_8_8, JavaLevelReader::new, JavaLevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_11, com.hivemc.chunker.conversion.encoding.java.v1_11.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_11.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_13, com.hivemc.chunker.conversion.encoding.java.v1_13.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_13.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_14, com.hivemc.chunker.conversion.encoding.java.v1_14.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_14.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_15, com.hivemc.chunker.conversion.encoding.java.v1_15.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_15.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_16, com.hivemc.chunker.conversion.encoding.java.v1_16.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_16.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_17, com.hivemc.chunker.conversion.encoding.java.v1_17.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_17.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_18, com.hivemc.chunker.conversion.encoding.java.v1_18.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_18.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_19_3, com.hivemc.chunker.conversion.encoding.java.v1_19_3.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_19_3.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_20, com.hivemc.chunker.conversion.encoding.java.v1_20.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_20.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_20_3, LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_20_3.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_20_5, com.hivemc.chunker.conversion.encoding.java.v1_20_5.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_20_5.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_21, com.hivemc.chunker.conversion.encoding.java.v1_21.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_21.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_21_2, com.hivemc.chunker.conversion.encoding.java.v1_21_2.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_21_2.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_21_4, com.hivemc.chunker.conversion.encoding.java.v1_21_4.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_21_4.writer.LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_21_6, com.hivemc.chunker.conversion.encoding.java.v1_21_6.reader.LevelReader::new, LevelWriter::new);
        JavaEncoders.register(JavaDataVersion.V1_21_9, com.hivemc.chunker.conversion.encoding.java.v1_21_9.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.java.v1_21_9.writer.LevelWriter::new);
    }

    public record JavaEncoder(JavaLevelReaderConstructor<?> readerConstructor, JavaLevelWriterConstructor<?> writerConstructor) {
    }
}

