/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.v1_18_30.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockChunkWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockWorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_18_30.writer.ChunkWriter;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;
import org.jetbrains.annotations.Nullable;

public class ColumnWriter
extends com.hivemc.chunker.conversion.encoding.bedrock.v1_18.writer.ColumnWriter {
    public ColumnWriter(BedrockWorldWriter parent, Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension) {
        super(parent, converter, resolvers, database, dimension);
    }

    public static byte[] generateStorageKeyForEntity(long uniqueEntityID) {
        long storageKey = 0x100000000L + (uniqueEntityID ^ 0xFFFFFFFF00000000L);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(storageKey);
        return buffer.array();
    }

    @Override
    protected void writeEntities(ChunkerColumn column) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                for (Entity entity : column.getEntities()) {
                    try {
                        byte[] key = this.writeKeyedEntity(column, entity);
                        if (key == null) continue;
                        writerStream.write(key);
                    }
                    catch (Exception e) {
                        this.converter.logNonFatalException(new Exception("Failed to process Entity " + String.valueOf(entity), e));
                    }
                }
            }
            this.database.put(LevelDBKey.key(LevelDBKey.DIGP_PREFIX, this.dimension, column.getPosition()), byteArrayOutputStream.toByteArray());
        }
    }

    protected byte @Nullable [] writeKeyedEntity(ChunkerColumn column, Entity entity) throws Exception {
        byte[] key = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                CompoundTag tag = this.writeEntity(column, entity);
                if (tag != null) {
                    long uniqueEntityID;
                    if (!tag.contains("UniqueID")) {
                        uniqueEntityID = this.parent.generateUniqueEntityID();
                        tag.put("UniqueID", uniqueEntityID);
                    } else {
                        uniqueEntityID = tag.getLong("UniqueID");
                    }
                    key = ColumnWriter.generateStorageKeyForEntity(uniqueEntityID);
                    Tag.encodeNamed(Writer.toBedrockWriter(writerStream), "", tag);
                }
            }
            if (key != null) {
                this.database.put(LevelDBKey.key(LevelDBKey.ACTOR_PREFIX, key), byteArrayOutputStream.toByteArray());
            }
            byte[] byArray = key;
            return byArray;
        }
    }

    protected byte getBlendingVersion() {
        return 0;
    }

    protected byte getChunkVersion() {
        return 40;
    }

    @Override
    protected void writeMetadata(ChunkerColumn chunkerColumn) throws Exception {
        try (WriteBatch writeBatch = this.database.createWriteBatch();){
            if (this.isWriteBlendingData()) {
                writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.GENERATED_PRE_CAVES_AND_CLIFFS_BLENDING), new byte[]{0});
                writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.VERSION), new byte[]{this.getChunkVersion()});
                writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.BLENDING_DATA), new byte[]{0, this.getBlendingVersion()});
            }
            writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.LEGACY_VERSION), new byte[]{7});
            this.database.write(writeBatch);
        }
    }

    @Override
    public BedrockChunkWriter createChunkWriter(ChunkerColumn column) {
        return new ChunkWriter(this.converter, this.resolvers, this.database, this.dimension, column);
    }
}

