/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockChunkWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockWorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.encoding.bedrock.util.PaletteUtil;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.writer.ChunkWriter;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.BedrockHeightMap;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.HeightMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.io.Writer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Collections;
import java.util.List;
import org.iq80.leveldb.DB;

public class ColumnWriter
extends com.hivemc.chunker.conversion.encoding.bedrock.v1_17.writer.ColumnWriter {
    public ColumnWriter(BedrockWorldWriter parent, Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension) {
        super(parent, converter, resolvers, database, dimension);
    }

    @Override
    protected void writeHeightMapBiomes(ChunkerColumn column) throws Exception {
        byte[] bytes;
        BedrockHeightMap heightMap;
        HeightMap heightMap2 = column.getHeightMap();
        if (!(heightMap2 instanceof BedrockHeightMap)) {
            heightMap = this.generateHeightMap(column);
        } else {
            BedrockHeightMap bedrockHeightMap = (BedrockHeightMap)heightMap2;
            heightMap = bedrockHeightMap;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            List biomesChunkList;
            Writer writer = Writer.toBedrockWriter(dataOutputStream);
            short[][] heightMapValues = heightMap.getHeightMap();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    writer.writeShort(heightMapValues[x][z]);
                }
            }
            List<Object> list = biomesChunkList = column.getBiomes() == null ? Collections.emptyList() : column.getBiomes().asPalette();
            if (!biomesChunkList.isEmpty() && !this.converter.level().map(level -> level.getSettings().CavesAndCliffs).orElse(true).booleanValue()) {
                SingleValuePalette<ChunkerBiome> palette = (SingleValuePalette<ChunkerBiome>)biomesChunkList.get(0);
                if (palette.isEmpty()) {
                    palette = new SingleValuePalette<ChunkerBiome>(16, this.resolvers.getFallbackBiome(this.dimension));
                }
                for (int i = 0; i < 4; ++i) {
                    biomesChunkList.add(0, palette);
                }
            }
            for (int i = 0; i < 64; ++i) {
                Palette<Object> palette;
                if (i >= biomesChunkList.size()) {
                    palette = !column.getChunks().isEmpty() && !biomesChunkList.isEmpty() ? (Palette)biomesChunkList.get(biomesChunkList.size() - 1) : EmptyPalette.chunk();
                } else {
                    palette = (EmptyPalette)biomesChunkList.get(i);
                    if (palette.isEmpty()) {
                        palette = new SingleValuePalette<ChunkerBiome>(16, this.resolvers.getFallbackBiome(this.dimension));
                    }
                }
                if (i >= biomesChunkList.size() && i >= this.getDimensionBiomeHeight()) continue;
                PaletteUtil.writeChunkPalette(writer, palette, true, true, biome -> writer.writeInt(this.resolvers.writeBiomeID((ChunkerBiome)biome, this.dimension)));
            }
            bytes = byteArrayOutputStream.toByteArray();
        }
        this.database.put(LevelDBKey.key(this.dimension, column.getPosition(), LevelDBChunkType.DATA_3D), bytes);
    }

    @Override
    public BedrockChunkWriter createChunkWriter(ChunkerColumn column) {
        return new ChunkWriter(this.converter, this.resolvers, this.database, this.dimension, column);
    }

    public int getDimensionBiomeHeight() {
        return switch (this.dimension) {
            case Dimension.OVERWORLD -> 24;
            case Dimension.NETHER -> 8;
            case Dimension.THE_END -> 16;
            default -> 24;
        };
    }
}

