/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.util;

import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.EmptyPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.ShortBasedPalette;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.SingleValuePalette;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.scheduling.function.ThrowableConsumer;
import com.hivemc.chunker.scheduling.function.ThrowableFunction;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class PaletteUtil {
    public static final int[] BITS_PER_ENTRY = new int[]{1, 2, 3, 4, 5, 6, 8, 16};
    public static final int EMPTY_PALETTE_BITS = 127;

    public static <T> Palette<T> readChunkPalette(ByteBuffer buffer, ThrowableFunction<Boolean, T> readPaletteEntry) throws Exception {
        int size;
        int paletteData = buffer.get() & 0xFF;
        int bitsPerEntry = paletteData >> 1;
        if (bitsPerEntry == 127) {
            return EmptyPalette.chunk();
        }
        int valuesPerWord = bitsPerEntry == 0 ? 0 : (int)Math.floor(32.0 / (double)bitsPerEntry);
        int wordSize = valuesPerWord == 0 ? 0 : (int)Math.ceil(4096.0 / (double)valuesPerWord);
        boolean runtimeEncoding = (paletteData & 1) != 0;
        int beforeWords = buffer.position();
        buffer.position(beforeWords + wordSize * 4);
        int n = size = bitsPerEntry == 0 ? 1 : buffer.getInt();
        if (size == 0) {
            return EmptyPalette.chunk();
        }
        if (size == 1) {
            return SingleValuePalette.chunk(readPaletteEntry.apply(runtimeEncoding));
        }
        ArrayList<T> keys = new ArrayList<T>(size);
        for (int j = 0; j < size; ++j) {
            keys.add(readPaletteEntry.apply(runtimeEncoding));
        }
        int afterKeys = buffer.position();
        buffer.position(beforeWords);
        short[][][] values = new short[16][16][16];
        int i = 0;
        for (int word = 0; word < wordSize; ++word) {
            int wordValue = buffer.getInt();
            for (int block = 0; block < valuesPerWord && i < 4096; ++i, ++block) {
                int x = i >> 8 & 0xF;
                int y = i & 0xF;
                int z = i >> 4 & 0xF;
                values[x][y][z] = (short)(wordValue >>> i % valuesPerWord * bitsPerEntry & (1 << bitsPerEntry) - 1);
            }
        }
        buffer.position(afterKeys);
        return new ShortBasedPalette(keys, values);
    }

    public static <T> void writeChunkPalette(Writer writer, Palette<T> palette, boolean runtimeEncoding, boolean supportsEmpty, ThrowableConsumer<T> writePaletteEntry) throws Exception {
        boolean emptyPalette = palette.isEmpty();
        if (supportsEmpty && emptyPalette) {
            writer.writeByte((byte)((runtimeEncoding ? 1 : 0) | 0xFE));
            return;
        }
        int index = 0;
        int bitsPerBlock = BITS_PER_ENTRY[index];
        if (!emptyPalette) {
            while (palette.getKeyCount() > 1 << bitsPerBlock) {
                bitsPerBlock = BITS_PER_ENTRY[++index];
            }
        }
        int maxValue = (1 << bitsPerBlock) - 1;
        int blocksPerWord = (int)Math.floor(32.0 / (double)bitsPerBlock);
        int wordSize = (int)Math.ceil(4096.0 / (double)blocksPerWord);
        int[] buffer = new int[wordSize];
        int i = 0;
        if (!emptyPalette && palette.getKeyCount() > 1 && palette instanceof ShortBasedPalette) {
            ShortBasedPalette shortBasedPalette = (ShortBasedPalette)palette;
            short[][][] values = shortBasedPalette.getValues();
            for (int wordIndex = 0; wordIndex < buffer.length; ++wordIndex) {
                for (int blockIndex = 0; blockIndex < blocksPerWord && i < 4096; ++i, ++blockIndex) {
                    int y = i & 0xF;
                    int z = i >> 4 & 0xF;
                    int x = i >> 8 & 0xF;
                    int startBitIndex = bitsPerBlock * blockIndex;
                    short value = values[x][y][z];
                    buffer[wordIndex] = buffer[wordIndex] & ~(maxValue << startBitIndex) | (value & maxValue) << startBitIndex;
                }
            }
        }
        writer.writeByte((byte)((runtimeEncoding ? 1 : 0) | bitsPerBlock << 1));
        for (Object entry : (ShortBasedPalette)buffer) {
            writer.writeInt((int)entry);
        }
        int keyCount = palette.getKeyCount();
        writer.writeInt(keyCount);
        if (keyCount > 0) {
            for (int keyIndex = 0; keyIndex < keyCount; ++keyIndex) {
                writePaletteEntry.accept(palette.getKey(keyIndex));
            }
        }
    }
}

